pro apdrates,starid,predictedrate
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Propagate the stellar flux through the atmosphere and NPOI, and return
; the predicted count rate for every NPOI channel.
;
; Number of reflections by the time star light is entering the lab building:
;
; Siderostat, NAT, elevator can (N/W=2x, E=3x), Feed can (AC and AE only),
; array center (N, W only), periscope, LDL manifold (3x) + LDL pop-up (2x),
; beam compressor (2x), FDL (3x), switch yard (2x), BC (1x or 2x),
; spectrometer (3x)
;
; Total of 22 for beams 1,2,3; 23 reflections for beams 4,5,6. Beams 1,2,3
; have one more beam splitter reflection.
;
; New info from SPIE 2006 poster:
; Feed system: 0.5-0.76
; FDL & SW: 0.72-0.84
; NAY: 0.8
; BC unused ports: 0.5
; Spectr. injection: 0.46
; Lenslet injection: 0.8
; Detector QE: 0.3
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Get predicted count rate/cm^2/s/nm
rates=stellarrate[starid,l]
l=l*1e9			; Change to lambda in nm
;
coat_t=0.99		; Transmission of coated window surfaces
unct_t=0.96		; Transmission of uncoated lenslet surfaces
s_rms=(850/l)/30	; Quality of mirror surface in units of lambda @ 850nm
p_rms=s_rms*2*!pi	; Phase rms across surface
ffld_t=exp(-p_rms^2/2)	; Far-field transmission due to mirror roughness
;
case systemid of
;
'NPOI':	begin
	aper=!pi*(12.5/2)^2	; Aperture 12.5 cm
	ci_t=1./500		; Coherent integration time 2 ms
	pickup=0.2		; That's what the NAT tracker BS takes away
	bc_t=0.25		; Beamcombiner (2 50/50) transmission
	throughput=(silver(l)*ffld_t)^22 $
	 *(1-pickup)*bc_t  $
	 *coat_t^12 $		; 3 windows (fdl passed twice), + prism & lens
	 *unct_t^5*apd(l)	; Lenslets have two lens design, + MM fiber
	f=throughput*rates*atmosphere(l)*aper*ci_t
	index=where(l gt 550 and l lt 850)
	print,'Average throughput [%]: ',avg(throughput[index])*100
	end
;
'Mark3':begin
	aper=!pi*(5.0/2)^2
	bc_t=0.5
	ci_t=1./250
	f=rates*atmosphere(l)*aper*silver(l)^7*coat_t^2*bc_t $
	 *unct_t^1*pmt(l)*ci_t
	end
;
endcase
;
; Integrate over bandpass, with proper compensation for lambda stepsize
predictedrate=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan))
for ob=0,GenConfig.NumOutBeam-1 do begin
for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
; 	Compute including duty cycle correction
	predictedrate[ob,ch]=total(f*generic_c(l,ch,ob))*(l[1]-l[0]) $
			    *(GenConfig.Wavelength[ch,ob]/1000e-9)
endfor
endfor
;
end
