function apodize_f,radius,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Should be called when computing visibilities from maps in order to exclude
; emission outside the field of view. Takes radius [mas] and lamda[m],
; and uses the telescope diameter [m] stored in GenConfig to return
; apodization factor.
;
; Either radius or lamda can be arrays, but not both.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if genconfig.diameter[0] eq 0 then return,1.0
;
rad2mas=180l*3600l*1000l/!pi
; Compute Airy's disk
airy=(lamda/genconfig.diameter[0])*rad2mas
return,exp(-(2*radius/airy)^2)	; Gaussian approximation (no sidelobes)
return,sinc(radius/airy)^2	; Airy pattern itself
;
end
