function apodize_m,r0,am
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
forward_function componentflux
;
; For multiple stellar systems, compute photocenter convolved with telescope
; PSF and return magnitude differences corresponding to the apodisation.
;
; r0 is the zenithal seeing at 500 nm (Fried's parameter), am the airmass.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
rad2mas=180l*3600l*1000l/!pi
lamda=gen_model.wavelengths*1e-6
;
if num_binary() eq 0 then return,0
;
; r0 is the zenith seeing (Fried's parameter) at 550 nm in arcseconds
if n_elements(r0) eq 0 then r0=1.0 else r0=float(r0)
;
; Compute component positions xy relative to center of mass
parsedate,date,y,m,d
epoch=julian(y,m,d)-2440000.d0
xy=reform(modelpos(epoch))
;
n=n_elements(star_model[where(star_model.type gt 0)])
n_stars=n
m=n_elements(lamda)
fl=fltarr(n,m)
dm=fltarr(n,m)
;
; Make backup copy of star_model
star_model_0=star_model
;
; Iterate
teff=star_model.teff
index=where(star_model.teff eq -5555,count)
if count ge 1 then star_model[index].teff=0
index=where(star_model.type eq 15,count)
if count ge 1 then star_model[index].teff=-star_model[index].teff
for l=0,5 do begin
;
; 	Weigh xy with component fluxes
	for i=0,n-1 do $
		fl[i,*]=componentflux(star_model[i].component,epoch,lamda)
	tfl=total(fl,1)
	xyfl=fltarr(n,m,2)
	for j=0,m-1 do begin
	for k=0,1 do begin
		xyfl[*,j,k]=(xy[*,k]*fl[*,j])/tfl[j]
	endfor
	endfor
;	Coordinates of photometric center (for each wavelength)
	pcl=total(xyfl,1)
;	White light photometric center (tracking is common for all wavel.)
	pc=total(pcl,1)/m
;	Shift xy center of mass to photometric center
	xyl=fltarr(n,m,2)
	for j=0,m-1 do begin
	for k=0,1 do begin
;		xyl(*,j,k)=xy(*,k)-pcl(j,k)
		xyl[*,j,k]=xy[*,k]-pc[k]
	endfor
	endfor
;	Compute distances of components from photometric center
	radius=sqrt(total(xyl^2,3))
; 	Compute PSF as a function of wavelength (first approximation)
	airy=(lamda/genconfig.diameter[0])*rad2mas
	psf=sqrt(((r0*1000)*(lamda/550e-9)^(-0.2))^2+airy^2)
;	Compute IQ (image quality) from atmosphere and telescope TF instead...
;	http://www.eso.org/observing/etc/bin/simu/hawki
	psf=iq_total(lamda,am,abs(r0),genconfig.diameter[0])*1000	; [mas]
;	Compute flux corrections
	for i=0,n-1 do dm[i,*]=-2.5*alog10(exp(-(2*radius[i,*]/psf[*])^2))
;	Apply corrections for next iteration
;	for i=0,n_elements(star_model)-1 do $
	for i=0,n_stars-1 do $
	star_model(i).magnitudes(*)=star_model_0(i).magnitudes(*) $
				   +reform(dm(i,*))
;
endfor
;
; Restore input star_model
star_model=star_model_0
;
return,transpose(dm)
;
end
