function apollonius,sma,smb,pa,sfactor
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; pa is the position angle (positive sense) in radians.
;
a=float(sma)
b=float(smb)
p=float(pa)
factor=float(sfactor)
;
q=0
if p gt !pi/2 and p le !pi then begin
        q=1
        p=!pi-p
endif else if p gt !pi then begin
        q=2
        p=p-!pi
endif else if p lt 0 and p ge -!pi/2 then begin
        q=3
        p=-p
endif else if p lt -!pi/2 then begin
        q=4
        p=p+!pi
endif
;
a1=ellipse(a,b,!pi/2-p)
b1=sqrt(a^2+b^2-a1^2)
;
x1=b1*sqrt(1-((a*b)/(a1*b1))^2)
y1=((a*b)/(a1*b1))*b1
;
x2=x1
y2=y1*factor
;
a2=a1
b2=sqrt(x2^2+y2^2)
;
ab=a2*b2*(y2/b2)
asqplusbsq=a2^2+b2^2
;
af=sqrt((asqplusbsq+sqrt(asqplusbsq^2-4*ab^2))/2)
bf=sqrt((asqplusbsq-sqrt(asqplusbsq^2-4*ab^2))/2)
;
if x2 ne 0 then begin
        tanalphaplusbeta=y2/x2
        tanalphatimestanbeta=bf^2/af^2
        t1=tanalphaplusbeta*(1-tanalphatimestanbeta)
        t2=tanalphatimestanbeta
        alpha=atan((t1+sqrt(t1^2-4*t2))/2)
        beta =atan((t1-sqrt(t1^2-4*t2))/2)
endif else begin
        alpha=!pi/2
        beta =0
endelse
;
if factor lt 1 then paf=!pi/2-beta else paf=!pi/2-alpha
;
case q of
        0:paf=paf
        1:paf=!pi-paf
        2:paf=paf+!pi
        3:paf=-paf
        4:paf=paf-!pi
endcase
;
return,[af,bf,paf]
;
end
