pro apparentstar,times,stars,startable,ra_app,dec_app
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Calculate apparent star positions. Procedure calls C function apstar for calls
; to apparentstar in the NOVAS C-library of astrometry subroutines
; (Kaplan, G.H. et al. 1989, AJ, 97 1197).
; Input variables can be arrays to speed up processing.
;
; Format of date (string): YYYY-MM-DD
; times (double): seconds since 0 UTC.
; stars (string): star names as in startable.
;
; These are the units (type double):
; ra=Right Ascension in hours plus fraction thereof
; dec=Declination in degrees plus fractions thereof
; pmra=Centennial change in Ra in seconds of time due to proper motion
; pmdec=Centennial change in Dec in seconds of arc due to proper motion
; px=Parallax in arcseconds
; rv=Radial velocity in km/s
; mv=Visual magnitude
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Check input
num_times=n_elements(times)
num_stars=n_elements(stars)
if num_times ne num_stars then begin
	print,'***Error(APPARENTSTAR): times and stars have different lengths!'
	return
endif
;
; Allocate star data
starname=strarr(num_times)
starnumber=lonarr(num_times)
ra=dblarr(num_times)
ra_app=dblarr(num_times)
dec=dblarr(num_times)
dec_app=dblarr(num_times)
pmra=dblarr(num_times)
pmdec=dblarr(num_times)
px=dblarr(num_times)
rv=dblarr(num_times)
;
for i=0,n_elements(startable)-1 do begin
	index=where(stars eq startable[i].starid,count)
	if count gt 0 then begin
		starname[index]=startable[i].starid
		starnumber[index]=1
		ra[index]=startable[i].ra
		dec[index]=startable[i].dec
		pmra[index]=startable[i].pmra
		pmdec[index]=startable[i].pmdec
		px[index]=startable[i].px
		rv[index]=startable[i].rv
	endif
endfor
;
if total(starnumber) ne num_times then begin
	print,'Warning(APPARENTSTAR): '+ $
		'star information could not be obtained for all scans!'
endif
;
; UTC is in seconds. Remember, CONSTRICTOR point times are in milliseconds,
; averaged scan times are in seconds since 0 UT!
UTC=times
parsedate,Date,y,m,d
tjd=(UTC+GeoParms.TAI_UTC+GeoParms.TDT_TAI)/86400+julian(y,m,d)
;
status=linknload(!external_lib,'apstar',num_times,tjd, $
		starname,starnumber, $
		ra,dec,pmra,pmdec,px,rv,ra_app,dec_app)
if status ne 0 then print,'***Error(APPARENTSTAR): apstar returns code ',status
;
if num_times eq 1 then begin
	ra_app=ra_app[0]
	dec_app=dec_app[0]
endif
;
end
