pro assign_ids,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For the specified starids, which must all refer to a single catalog and must
; be found in the startable, check whether they are already present in the
; catalog file and if not, assign unused starids to them.
;
common StarBase,StarTable,Notes
;
catids=unique(strmid(starids,0,3))
if n_elements(catids) gt 1 then begin
	print,'***Error(CHECK_CAT): cannot check more than one catalog!'
	return
endif
table0=startable	; this table is not updated
table1=startable	; this table is updated
get_cat,catids[0]
cat_ids=startable.starid
cat_nms=startable.name
;
for i=0,n_elements(starids)-1 do begin
	index0=where(table0.starid eq starids[i],count0)
	if count0 eq 0 then begin
		print,'***Error(ASSIGN_IDS): star not found in startable!'
		startable=table0
		return
	endif
	index=where(cat_ids eq starids[i],count)
	if count eq 1 then begin
		if cat_nms[index] ne table0[index0].name then begin
;			Same ID, but different names => find new ID
			new_id=max(long(strmid(cat_ids,3,4)))+1
			starids[i]=strmid(starids[i],0,3)+string(new_id,format='(i4.4)')
			table1[index0].starid=starids[i]
			cat_ids=[cat_ids,starids[i]]
			cat_nms=[cat_nms,table1[index0].name]
		endif
;		Same ID and same name => same star, no need for new ID
	endif
	index=where(cat_nms eq table0[index0].name,count)
	if count eq 1 then begin
		starids[i]=cat_ids[index]
		table1[index0].starid=starids[i]
	endif
endfor
;
end
