pro astrocorr
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use the INCHWORM delay solution data to compute corrections.
; Note: results store in MetroPos, a variable shared with metrocorr, since
; both routines should give the same answer.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if checkdata([3,8,11,16]) ne 0 then return
;
print,'AstroCorr begins...'
;
; Do we want a plot?
do_plot=0
;
; Allocate data
MetroPos=fltarr(GenConfig.NumSid,n_elements(PointTime))
MetroPosErr=fltarr(GenConfig.NumSid,n_elements(PointTime))-1
;
metrotimes=abs(MetroTime)
pointtimes=abs(PointTime)
;
; Go through available point data one scan at a time
FOR i=0,n_elements(Iscan)-1 DO BEGIN
;
index=where(metrotimes ge pointtimes[Rec0[i]] $
	and metrotimes le pointtimes[RecN[i]],count)
;
if count eq 0 then begin
	print,'Warning(ASTROCORR): no data for scan ',Iscan[i],'!'
	goto,DONEXT
endif
;
times=MetroTime[index]
delay=MetroPath[*,index]
delayerr=MetroPathErr[*,index]
;
index=where(times gt 0,count)
;
if count eq 0 then begin
	print,'Warning(ASTROCORR): no data for scan ',Iscan[i],'!'
	goto,DONEXT
endif
times=times[index]
delay=delay[*,index]
delayerr=delayerr[*,index]
;
for j=0,GenConfig.NumSid-1 do begin
	d=delay[j,*]
	e=delayerr[j,*]
	index=where(e gt 0,count)
	if count gt 1 then begin
	w=1/e[index]^2
	r=poly_fit(times[index],d[index],1,measure_errors=e,yfit=yft,yband=ybd,sigma=si
;	MetroPos(j,Rec0(i):RecN(i))=poly(pointtimes(Rec0(i):RecN(i)),r)
	MetroPos[j,Rec0[i]:RecN[i]]=spline(times[index],d[index],pointtimes[Rec0[i]:Rec
	MetroPosErr[j,Rec0[i]:RecN[i]]=sig
;
	if do_plot then begin
	plot,pointtimes[rec0[i]:recn[i]]/3600,MetroPos[j,rec0[i]:recn[i]], $
		xtitle='UT [h]',ytitle='c [microns], Sid'+string(j+1), $
		title='Scan'+string(Iscan[i]),psym=3,charsize=1.5
	oplot,times[index]/3600,d[index],psym=1
	oploterr,times[index]/3600,d[index],e,3
	xyouts,0.01,0.01,'Sigma='+string(sig),/normal
	endif
;
	endif
endfor
;
DONEXT:
ENDFOR
;
; Convert to "pos" format
for j=0,GenConfig.NumSid-1 do begin
	if j ne GenConfig.RefStation-1 then $
	MetroPos[j,*]=MetroPos[j,*]-MetroPos[GenConfig.RefStation-1,*]
endfor
;
print,'Finished AstroCorr computation.'
;
end
