pro av_stars,amores=amores,drimmel=drimmel
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute Av for all stars in startable using tools by Amores and Lepine 2005
; (AJ, 130, 679, http://www.astro.iag.usp.br/~amores/modextin.html) or Drimmel
; et al. 2003 (A&A, 409, 205, ftp://ftp.oato.inaf.it/astrometria/extinction/).
;
common StarBase,startable,notes
;
if n_elements(amores) eq 0 then amores=0
if n_elements(drimmel) eq 0 then drimmel=0
if amores eq 0 and drimmel eq 0 then begin
	print,'Using model by Amores and Lepine 2005.'
	amores=1
endif
;
index=where(startable.px gt 0,count)
if count eq 0 then begin
	print,'Error: all parallaxes zero or negative!'
	return
endif
table=startable[index]
d=1.0/table.px & d=d/1000	; kpc
;
ra=table.ra*15
dec=table.dec
euler,ra,dec,glong,glat,1
;
if drimmel then begin
	findext,glong,glat,d,av,avmod
	startable[index].av=av
;	for i=0,count-1 do begin
;	findext,glong(i),glat(i),d(i),av,avmod
;	startable(index(i)).av=av
;	endfor
endif
if amores then begin
	for i=0,count-1 do begin
	extin,glong[i],glat[i],d[i],av,ebv
	startable[index[i]].av=av
	endfor
endif
;
end
