function azel2horizon,a_coord
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convert azimuth angle (0=N, 90=W) and elevation angle to horizontal
; coordinates.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
b=fltarr(1,n_elements(a_coord[0,*]))
h_coord=[a_coord,b]
h_coord[0,*]=-sin(a_coord[0,*]/RAD)*cos(a_coord[1,*]/RAD)
h_coord[1,*]= cos(a_coord[0,*]/RAD)*cos(a_coord[1,*]/RAD)
h_coord[2,*]= 		            sin(a_coord[1,*]/RAD)
;
return,h_coord
;
end
