pro bad_cals
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read bad calibrator registry list (tab format), calibrators.bcr,
; using the ascii template calibrators.tpl. Check if there are matches
; with stars in StarTable with bflag='C', and remove these (set to '.')
; Notify of bad calibrators!
;
; Create input calibrators.bcr using copy/paste of the table at
; http://www.jmmc.fr/badcal/show.jsp?type=all&display=complet
;
; To use this procedure, one has to create the ASCI template as follows:
; template=ascii_template('~/oyster/starbase/calibrators.bcr')
; (Except for a few strings, e.g., coordinates, all other are recognized)
; save,template,file='~/oyster/starbase/calibrators.tpl'
; The template can then be used to read the data:
; restore,'~/oyster/starbase/calibrators.tpl'
; data=read_ascii('calibrators.bcr',template=template)
;
common StarBase,StarTable,Notes
;
restore,!oyster_dir+'starbase/calibrators.tpl'
bc=read_ascii(!oyster_dir+'starbase/calibrators.bcr',template=template)
;
num_badcal=0
index=where(startable.bflag eq 'C',count)
for i=0,count-1 do begin
	w=winkel(startable[index[i]].ra*15,startable[index[i]].dec, $
		bc.field02,bc.field03)*3600	; ["]
	j=where(w lt 60,n)
	if n eq 1 then begin
		print,'BadCal found: '+startable[index[i]].starid
		startable[index[i]].bflag='.'
		num_badcal=num_badcal+1
	endif else if n gt 1 then begin
		print,'More than 1 bad CAL near SCI! (' $
			+strjoin(bc.field06[j],' ')+')'
		startable[index[i]].bflag='.'
	endif
endfor
if num_badcal eq 0 then print,'No bad calibrators known.'
;
end
