function baselinecoord,ob,bl,utc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes equatorial baseline coordinates from station coordinates.
; Convention used is: station 2 - station 1. That way, a baseline vector
; B_12 is oriented from telescope 1 to telescope 2.
; Also applies polar motion corrections.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
i=where(GenConfig.StationId[0:GenConfig.NumSid-1] $
	eq strmid(GenConfig.BaselineId[bl,ob],0,3))
j=where(GenConfig.StationId[0:GenConfig.NumSid-1] $
	eq strmid(GenConfig.BaselineId[bl,ob],4,3))
e_coord= $
   horizon2equatorial(GenConfig.StationCoord[*,j]-GenConfig.StationCoord[*,i])
;
n_utc=n_elements(utc)
pos1=dblarr(3,n_utc,/nozero)
pos2=pos1
pos1[0,*]=e_coord[0]
pos1[1,*]=e_coord[1]
pos1[2,*]=e_coord[2]
utc_days=utc/86400
pole_x=poly(utc_days,GeoParms.pole_x_coeffs)
pole_y=poly(utc_days,GeoParms.pole_y_coeffs)
status=linknload(!external_lib,'polarmotion',n_utc,pole_x,pole_y,pos1,pos2)
;
; We still don't trust pos2 even though I think it was tested
return,pos1
;
end
