function bc_teff,teff
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns bolometric correction bc (m_bol=m+bc) according to polynomial fits
; given in Flower, 1996 and confirmed by Torres 2010.
;
teff=float(teff)
lte=alog10(teff)
;
c1=[-0.190537291496456D+05, $
     0.155144866764412D+05, $
    -0.421278819301717D+04, $
     0.381476328422343D+03]
c2=[-0.370510203809015D+05, $
     0.385672629965804D+05, $
    -0.150651486316025D+05, $
     0.261724637119416D+04, $
    -0.170623810323864D+03]
c3=[-0.118115450538963D+06, $
     0.137145973583929D+06, $
    -0.636233812100225D+05, $
     0.147412923562646D+05, $
    -0.170587278406872D+04, $
     0.788731721804990D+02]
;
i1=where(lte lt 3.7,n1)
i2=where(lte ge 3.7 and lte le 3.9,n2)
i3=where(lte gt 3.9,n3)
;
bcorr=teff
if n1 gt 0 then bcorr[i1]=poly(lte[i1],c1)
if n2 gt 0 then bcorr[i2]=poly(lte[i2],c2)
if n3 gt 0 then bcorr[i3]=poly(lte[i3],c3)
;
return,bcorr
;
end
