function beamcombiner_id,sysid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the beam combiner ID for the given system/instrument,
; e.g. VLTI/MIDI-N-PRISM. If the instrument is not defined, return 1.
; System refers to the interferometer (e.g. NPOI), instrument to the combiner.
; For aperture masks, system should be the instrument name (e.g. NACO),
; and instrument refers to the specific mask (e.g. 7Holes)
;
; This function is the only one which needs to know non-standard instruments,
; as it is called by get_oifits to return a beam combiner ID known to OYSTER.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
;
words=nameparse(sysid,'/')
; if n_elements(words) lt 2 then return,1
;
case words[0] of
'T-ReCS':begin
	if strpos(words[1],'7Holes') ge 0 then return,1
	end
'NACO':	begin
	if strpos(words[1],'7Holes') ge 0 then return,1
	end
'JWST_SIM':begin
	if strpos(words[1],'7Holes') ge 0 then return,1
	end
'SUSI': begin
	return,1
	end
'ISI': 	begin
	if strpos(words[1],'4') ge 0 then return,1
	end
'Mark3':begin
	index=where(mark3_configs eq words[1])
	return,index[0]+1
	end
'PTI':	begin
	if strpos(words[1],'K1') ge 0 then return,1
	if strpos(words[1],'K5') ge 0 then return,2
	if strpos(words[1],'Synthetic_WL') ge 0 then return,1
	end
'IOTA':	begin
	if strpos(words[1],'IONIC3') ge 0 then return,1
	if strpos(words[1],'IONIC') ge 0 then return,2
	end
'COAST':begin
	return,1
	end
'NPOI':	begin
	if strpos(words[1],'3way') ge 0 then return,1
	if strpos(words[1],'6way') ge 0 then return,2
	if strpos(words[1],'nway') ge 0 then return,9
	return,9
	end
'CHARA':begin
	if strpos(words[1],'CLASSIC') ge 0 then return,10
	if strpos(words[1],'CLIMB') ge 0 then return,20
	if strpos(words[1],'H_PRISM') ge 0 then return,30
	if strpos(words[1],'MIRC-LR') ge 0 then return,31
	if strpos(words[1],'MIRC-MR') ge 0 then return,32
	if strpos(words[1],'MIRC-HR') ge 0 then return,33
	if strpos(words[1],'MIRC') ge 0 then return,30
	end
'Keck':	begin
	if strpos(words[1],'K1') ge 0 then return,1
	if strpos(words[1],'KIN') ge 0 then return,2
	end
'VLTI':	begin
	if strpos(words[1],'VINCI-MONA') ge 0 then return,11
	if strpos(words[1],'VINCI-IONIC') ge 0 then return,12
	if strpos(words[1],'MIDI-N-PRISM') ge 0 then return,21
	if strpos(words[1],'MIDI-N-GRISM') ge 0 then return,22
	if strpos(words[1],'AMBER-LR') ge 0 then return,31
	if strpos(words[1],'AMBER-MR') ge 0 then return,32
	if strpos(words[1],'AMBER-HR') ge 0 then return,33
	if strpos(words[1],'PIONIER-GRIS') ge 0 then return,41
	if strpos(words[1],'PIONIER-FREE') ge 0 then return,42
	if strpos(words[1],'PIONIER_P') ge 0 then return,41
	if strpos(words[1],'GRAVITY-LR') ge 0 then return,51
	if strpos(words[1],'GRAVITY-MR') ge 0 then return,52
	if strpos(words[1],'GRAVITY-HR') ge 0 then return,53
	if strpos(words[1],'MATISSE-LN') ge 0 then return,61
	if strpos(words[1],'MATISSE-L-LR') ge 0 then return,62
	if strpos(words[1],'MATISSE-L-MR') ge 0 then return,63
	if strpos(words[1],'MATISSE-L-HR') ge 0 then return,64
	if strpos(words[1],'MATISSE-L-HP') ge 0 then return,65
	if strpos(words[1],'MATISSE-N-LR') ge 0 then return,66
	if strpos(words[1],'MATISSE-N-HR') ge 0 then return,67
;	Deduce config ID from spectrometer layout
	if strpos(words[1],'AMBER') ge 0 then begin
		if max(genconfig.numspecchan) lt 50 then return,31
		if max(genconfig.numspecchan) lt 5000 then return,32
		if max(genconfig.numspecchan) lt 50000 then return,33
	endif
	if strpos(words[1],'PIONIER') ge 0 then begin
		if genconfig.numspecchan[0] gt 1 then return,41
		if genconfig.numspecchan[0] eq 1 then return,42
	endif
	if strpos(words[1],'GRAVITY') ge 0 then begin
		if max(genconfig.numspecchan) le 40 then return,51
		if max(genconfig.numspecchan) le 400 then return,52
		if max(genconfig.numspecchan) le 4000 then return,53
	endif
	if strpos(words[1],'MATISSE') ge 0 then begin
		if genconfig.numoutbeam eq 2 then return,61
		nc=genconfig.numspecchan & nc=nc[0]
		dl=genconfig.wavelength[1:nc-1] $
		  -genconfig.wavelength[0:nc-2]
	  	med_dl=abs(median(dl)*1e6)
		if median(genconfig.wavelength)*1e6 lt 7 then begin
;			L-band
			if med_dl lt 0.0001 then return,65
			if med_dl lt 0.001 then return,64
			if med_dl lt 0.01 then return,63
			return,62
		endif else begin
;			N-band
			if max(genconfig.numspecchan) le 150 then return,66
			if max(genconfig.numspecchan) gt 150 then return,67
		endelse
	endif
	return,1
	end
endcase
;
end
