function beamconfig,beam,scanids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return scan configuration for every scan ID accounting for which
; stations are present in the specified output beam.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(scanids) eq 0 then scanids=indgen(n_elements(scantable))+1
;
stations=unique(nameparse(strjoin( $
  genconfig.baselineid[0:genconfig.numbaseline[beam-1]-1,beam-1],'-'),'-'))
;
beams=scantable[scanids-1].station(0:genconfig.numsid-1)
for i=0,genconfig.numsid-1 do begin
	index=where(stations eq genconfig.stationid[i],count)
	if count eq 0 then beams[i,*]=0
endfor
;
return,beams
;
end
