function beampatch,beam,level=level,radius=radius
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return a map with the beam patch, i.e. all pixel values greater than 1/5
; of the maximum set to 1, all others set to 0. Use radius [pixels] to blank
; all pixels outside the specified radius.
;
; Supercedes version above with better results.
;
if n_elements(level) eq 0 then level=0.1
if n_elements(radius) eq 0 then radius=0
;
imsize=n_elements(beam[*,0])
jmsize=n_elements(beam[0,*])
;
; Rotate and add
beam_in=beam
beam=(beam_in+rotate(beam_in,45)+rotate(beam_in,90)+rotate(beam_in,135))/4
; tvscl,beam
;
if radius ne 0 then begin
	b=shift(dist(imsize,jmsize),imsize/2,jmsize/2)
	b=-b+max(b)
	index=where(b lt sqrt(2)*((imsize+jmsize)/4-radius))
	beam[index]=0
endif
;
b=fltarr(imsize+2,jmsize+2)
patch=b
b[1:imsize,1:jmsize]=beam
bmax=max(b)
blim=bmax*level
;
i0=imsize/2+1
j0=jmsize/2+1
;
; Assume peak is at center
index=where(beam eq max(beam))
i0=index[0] mod imsize
j0=index[0] / jmsize
if 2*(i0+1) ne imsize or 2*(j0+1) ne jmsize then begin
	print,'Error(beampatch): beam is not at center!'
	return,0
endif
;
i=0l
repeat begin
	j=0l
	while b[i0+i,j0-j] gt blim do begin
		patch[i0+i,j0-j]=1
		j=j+1
	endwhile
	j1=j
	j=1l
	while b[i0+i,j0+j] gt blim do begin
		patch[i0+i,j0+j]=1
		j=j+1
	endwhile
	j2=j
	j0=j0+(j2-j1)/2
	i=i+1
endrep until b[i0+i,j0] le blim
;
i=1l
j0=jmsize/2+1
repeat begin
	j=0l
	while b[i0-i,j0-j] gt blim do begin
		patch[i0-i,j0-j]=1
		j=j+1
	endwhile
	j1=j
	j=0l
	while b[i0-i,j0+j] gt blim do begin
		patch[i0-i,j0+j]=1
		j=j+1
	endwhile
	j2=j
	j0=j0+(j2-j1)/2
	i=i+1
endrep until b[i0-i,j0] le blim
;
; Restore beam to input
beam=beam_in
;
return,patch[1:imsize,1:jmsize]
;
end
