function bglocation,ra0,dec0,fsize=fsize
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return suitable location for measurement of background. Must not have
; any stars down to the magnitude limit of the used coordinate list within
; circle of diameter fsize.
;
; Diameter, in degrees, of field required to be empty of stars
; The necessary list of star positions is contained in file skycoord,
; which is just a list od Ra and Dec values from a catalog saved into
; an XDR file.
;
if n_elements(fsize) eq 0 then fsize=30./60
;
; Read (into ra,dec) stellar coordinates from a mag. lim. list for b.g. fields
restore,!oyster_dir+'npoi/skycoord.xdr'
;
RAD=180/!pi
;
; Center stellar field N (az=0, ha=0) at elevation zero,
; and convert to (az,el) coord.
lat=-(90-dec0)
azel=hadec2azel(transpose([[ra-ra0],[dec]]),lat=lat)
index=where(azel[0,*] gt 180)
azel[0,index]=azel[0,index]-360
az=reform(azel[0,*])
el=reform(azel[1,*])
;
; Do a spiral search beginning south with field centers separated by fsize/2
dr=fsize/2
pa=0.
repeat begin
        az0=-sin(pa/RAD)*dr
        el0=+cos(pa/RAD)*dr
        d=sqrt((az-az0)^2+(el-el0)^2)
        pa=pa+2*asin((fsize/4)/dr)*RAD
        if pa gt 360 then begin
                pa=0.
                dr=dr+fsize/2
        endif
endrep until min(d) gt fsize/2
;
hadec=azel2hadec([az0,el0],lat=lat)
hadec[0]=hadec[0]+ra0
;
return,hadec
;
end
