pro biasbase,files
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure updates the file biasbase.xdr in oyster/npoi with bias data
; from the specified files, if existent, i.e. non-zero. Therefore, there
; is no way knowing whether the non-zero coefficients have been derived
; from this night's data, or whether they have been used from another night
; using the get_bias procedure. The rule should be to write non-zero bias
; information only if it has been established with these data.
;
; Ideally, and ultimately, every night should include incoherent scans for
; the derivation of bias coefficients, but historically this has not been
; the case. Therefore this somewhat elaborate system to establish a bias
; database.
;
; Current list of dates entering biasbase:
; 2000-09-20 2000-09-26 2000-09-28 2000-09-29 2000-10-06 2000-10-18
; 2000-10-20 2000-11-29 2000-12-01 2001-06-21
;
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_params() eq 0 then begin
	print,'Usage: biasbase,files'
	print,'Required input: files.'
	return
endif
;
if n_elements(files) eq 1 then files=file_search(files[0])
nf=n_elements(files)
if strlen(files[0]) eq 0 then begin
	print,'***Error(BIASBASE): no files!'
	return
endif
maxConfig=NumSid
for i=2,GenConfig.NumSid do $
	maxConfig=maxConfig+combinations(GenConfig.NumSid,i)
;
name=!oyster_dir+'npoi/biasbase.xdr'
result=file_search(name,count=fcount)
if fcount eq 1 then begin
	restore,name	; restore variable database
	bb=database & nb=n_elements(bb)
	database=alloc_biasbase(strarr(nb+nf*maxConfig),bb[0].bias,'      ')
	database[0:nb-1].date=bb.date
	database[0:nb-1].bias=bb.bias
	database[0:nb-1].config=bb.config
endif else nb=0
;
j=0
for i=0,nf-1 do begin
	hds_open,files[i],'READ',status
	if status ne 0 then return
	get_genconfig
	if i eq 0 and nb eq 0 then $
		database=alloc_biasbase(strarr(nf),genconfig.bias,'      ')
	if total(abs(genconfig.bias)) gt 0 then begin
		get_data
		configs=scanconfig()
		for k=0,n_elements(configs)-1 do begin
		database[nb+j].bias=genconfig.bias[*,*,*,*,k]
		database[nb+j].date=checkdate()
		database[nb+j].config=configs[k]
		j=j+1
		endfor
	endif
	hds_close
endfor
if j eq 0 then begin
	print,'No bias data found!'
	return
endif
database=database[0:nb+j-1]
;
database=database[uniq(database.date+database.config, $
			sort(database.date+database.config))]
save,database,filename=name
;
if fcount eq 1 then print,'Biasbase updated' else print,'Biasbase created'
;
end
