function binarypos,epoch,component,lamda=lamda,abs=abs
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return separation and position angle for the specified binary
; component. Return absolute positions for each component if abs=1.
; Assume visual band is the requested wavelength if not specified.
; Epoch is the *full* Julian day number; if not specified, use
; today's date and the top level binary component.
;
; Please note: uses !cop system variable to select center-of-light or
; center-of-mass (use latter when computing nominal positions for *.psn
; model files! Otherwise, the center of light correction is applied twice!)
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(binary_model) eq 0 then begin
	print,'***Error(BINARYPOS): no model!'
	return,-1
endif
;
if n_elements(epoch) eq 0 then begin
	print,"Using today's date..."
        parseidldate,systime(),y,m,d
	epoch=julian(y,m,d)
endif
mjd=epoch-2440000L
;
if n_elements(component) eq 0 then component=topbincomp() $
			      else component=strupcase(component)
;
; Assume visual (speckle) band if not specified
if n_elements(lamda) eq 0 then lamda=550e-9
;
; Assume relative position, not absolute
if n_elements(abs) eq 0 then abs=0
;
rad=180/pi_circle
;
; Compute list of positions relative to center-of-mass
poslist=modelpos(mjd)
;
; Compute weights from masses and fluxes
if componentparse(component,c1,c2) ne 0 then return,-1
c1=nameparse(c1,'') & nc1=n_elements(c1)
c2=nameparse(c2,'') & nc2=n_elements(c2)
index1=intarr(nc1)
index2=intarr(nc2)
flux1=fltarr(nc1)
flux2=fltarr(nc2)
mass1=fltarr(nc1)
mass2=fltarr(nc2)
for i=0,nc1-1 do begin
	index1[i]=where(star_model.component eq c1[i])
	flux1[i]=stellarfluxes(star_model[index1[i]],lamda) $
		*modelfluxes(star_model[index1[i]],lamda)
	mass1[i]=star_model[index1[i]].mass
endfor
for i=0,nc2-1 do begin
	index2[i]=where(star_model.component eq c2[i])
	flux2[i]=stellarfluxes(star_model[index2[i]],lamda) $
		*modelfluxes(star_model[index2[i]],lamda)
	mass2[i]=star_model[index2[i]].mass
endfor
;
!cop=strupcase(!cop)
;
if !cop eq 'COM' then begin
;	Center of mass
	weight1=mass1
	weight2=mass2
endif else if !cop eq 'COL' then begin
;	Center of light
	weight1=flux1
	weight2=flux2
endif else if !cop eq 'COP' then begin
;	Primary component
	weight1=fltarr(nc1) & weight1[0]=1
	weight2=fltarr(nc1) & weight2[0]=1
endif
x1=total(poslist[0,index1,0]*weight1)/total(weight1)
x2=total(poslist[0,index2,0]*weight2)/total(weight2)
y1=total(poslist[0,index1,1]*weight1)/total(weight1)
y2=total(poslist[0,index2,1]*weight2)/total(weight2)
if abs then begin
	x=[x1,x2]
	y=[y1,y2]
endif else begin
	x=x2-x1
	y=y2-y1
endelse
rho=sqrt(x^2+y^2)
theta=atan(x,y)*rad
index=where(theta lt 0,count)
if count gt 0 then theta[index]=theta[index]+360
;
return,[[rho],[theta]]
;
end
