function binaryvel,epoch,component
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Epoch is the full Julian day number.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(binary_model) eq 0 then begin
	print,'***Error(BINARYVEL): no model!'
	return,-1
endif
;
if n_elements(epoch) eq 0 then begin
        parseidldate,systime(),y,m,d
	epoch=julian(y,m,d)
endif
;
vels=modelvel(epoch-2440000.d0)
if n_elements(component) eq 0 then component='A' $
			      else component=strupcase(component)
;
return,vels[where(star_model.component eq component)]
;
end
