function blackexp,teff,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Teff [K], lambda [microns]
;
; Compute fl_exp in (lambda_i/lambda_0)^fl_exp which is the slope of the
; blackbody spectrum at wavelength lambda [microns]: flux ~ (l/l_0)^-fl_exp.
;
r=blackbody(teff,lambda/1e6,fl_exp)
;
return,fl_exp
;
end
