function blacksphere,teff,lambda,diameter
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return flux in Jy for a blackbody sphere. Lambda [m], Teff [K], diameter [mas]
; Using Table 7.5 of Infrared Astronomy, in Allen's Astrophysical Quantities
;
flux=blackbody(teff,lambda,/jansky)
;
; l=[0.55,1.215,1.654,2.157,2.179,3.547,3.761,4.769,8.756,10.472,11.653,20.130]
; f=[3540,1630,1050,667,655,276,248,160,50,35.2,28.6,9.70]
;
f=1.88e-16
d=diameter/2.77		; Peterson et al. 2006
; p=distance*0.13023	; Vega parallax: 130.23 mas
;
return,flux*f*d^2
;
end
