pro bootstrap_vis,star_models_p,star_models_s,binary_models
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Template to carry out a "bootstrap" method to estimate parameter errors.
; Here, we do not replace data, but select a fraction of data (e.g., 90%)
; and repeat the parameter fit. The routine sets everything back when done
; and returns the fitted star and binary models. Selection of fit parameters
; is done via the ModelFit GUI.
;
forward_function cgRandomIndices
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
star_model_bck=star_model
binary_model_bck=binary_model
;
geninfo_bck=geninfo
geoinfo_bck=geoinfo
bufferinfo_bck=bufferinfo
;
num_nights=n_elements(geninfo)
sel_nights=long(0.7*num_nights)
;
n=num_nights
n=30	; Number of data subsets to fit
;
star_models_p=replicate(star_model[0],n)
star_models_s=replicate(star_model[1],n)
binary_models=replicate(binary_model,n)
;
for i=0,n-1 do begin
	indices = cgRandomIndices(num_nights,sel_nights,seed=seed)
	geninfo=geninfo_bck[indices]
	geoinfo=geoinfo_bck[indices]
	bufferinfo=bufferinfo_bck[indices]
	fitmodel
	star_models_p[i]=star_model[0]
	star_models_s[i]=star_model[1]
	binary_models[i]=binary_model
	star_model=star_model_bck
	binary_model=binary_model_bck
endfor
;
geninfo=geninfo_bck
geoinfo=geoinfo_bck
bufferinfo=bufferinfo_bck
;
star_model=star_model_bck
binary_model=binary_model_bck
;
end
