function box,x,j,dim
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Smooth values along dimension dim (first is 0) of a matrix x, over j samples.
;
if n_elements(dim) eq 0 then dim=0
;
if j eq 1 then return,x
;
result=size(x)
;
; n is the number of elements along dim
n=result[1+dim]
;
; k is the number of elements in each of the n sub-matrices
if dim eq 0 then k=1 else k=produkt(result[1:dim])
;
; l is the number of elements processed at a time
l=k*n
;
; Make output array
result=reform(make_array(size=result))
;
; m is the number of elements not including dim
m=n_elements(result)/n
;
for i=0L,m-1 do begin
	index=lindgen(n)*k+(i mod k)+(i/k)*l
	if j eq n_elements(index) $
		then result[index]=mean(x[index]) $
		else result[index]=smooth(x[index],j,/edge_truncate)
endfor
;
return,result
;
end
