pro calcastrom,compute=compute,skipuv=skipuv,quiet=quiet
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes astrometric quantities for all averaged scans.
; Do not (re)compute apparent positions for compute=0
; Do not compute uv-coordinates if skipuv=1
;
common LocalCalcAstrom,compute_app
common Tables,scantable,bgtable,stationtable
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if checkdata([3,9]) ne 0 then return
if n_elements(skipuv) eq 0 then skipuv=0
if n_elements(quiet) eq 0 then quiet=0
if total(genconfig.stationcoord) eq 0 then skipuv=1
;
; Compute the astrometry also for flagged data!
index=where(abs(scans.time) ge 0,count)
if count eq 0 then begin
	print,'***Error(CALCASTROM): no valid scan times found!'
	return
endif
;
; If not compute, use the apparent positions as stored in scans
if n_elements(compute_app) eq 0 then compute_app=1
if n_elements(compute) eq 0 then compute=compute_app
compute_app=compute
;
; Compute apparent star positions
times=abs(scans[index].time)
times=scans[index].time ; Version 9: time relative to UT=0 can be negative
stars=scans[index].StarId
if compute then begin
	topostar,times,stars,StarTable,ra_app,dec_app
endif else begin
	ra_app=scans.ra
	dec_app=scans.dec
endelse
;
; Compute UT1
ut1=utc2ut1(times)
;
; Compute Greenwich apparent sidereal time
gst=ut12gst(times,ut1)
;
; Compute hour angle
scans[index].ha=hourangle(gst,ra_app)
;
; Store Declination
scans[index].dec=dec_app
;
; Compute and store azimuth of star
hadec=transpose([[scans[index].ha],[scans[index].dec]])
azel=horizon2azel(equatorial2horizon(hadec2equatorial(hadec)))
scans[index].az=reform(azel[0,*])
;
; Store Right Ascension
scans[index].ra=ra_app
;
; Compute zenith angle
scans[index].za=zenithangle(scans[index].ha,dec_app)
;
; Compute mirror angle
scans[index].ma=mirrorangle(scans[index].ha,dec_app)
;
if skipuv then return
;
; Compute uv-coverage
uvw=dblarr(n_elements(scans[0].vissq(*,0,0)), $
	   n_elements(scans[0].vissq(0,*,0)), $
	   n_elements(scans[0].vissq(0,0,*)),3,n_elements(times))
scans[index].uvw=calcuv(scans[index].ha,dec_app,times,uvw)
;
; Treat white light source separately
jndex=where(scans.StarId eq 'FKV0000',count)
if count gt 0 then begin
	scans[jndex].uvw=0
	scans[jndex].ha=5	; nominal value
	scans[jndex].dec=12	; nominal value
endif
;
; Compute astrometric delay. Note that the delay offset is included!
if system_id(SystemId) eq 'NPOI' or system_id(SystemId) eq 'VLTI' then begin
scans[index].GeoDelay(0:GenConfig.NumSid-1)=stationdelay(scans[index].UVW)
j=GenConfig.NumSid
for i=0,GenConfig.NumSid-1 do if total(scans[index].GeoDelay(i)) eq 0 then j=i
if j eq GenConfig.NumSid then begin
	print,'***Error(CALCASTROM): problem with geometric delays!'
	return
endif
endif
;
; Reference to reference station
ibr=GenConfig.RefStation-1
for i=0,GenConfig.NumSid-1 do begin
      if i ne ibr then $
      scans[index].GeoDelay(i)= $
      scans[index].GeoDelay(i)-scans[index].GeoDelay(ibr)
endfor
scans[index].GeoDelay(ibr)=0
;
if not quiet then print,'Finished astrometry computations.'
;
end
