pro calcgeo
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute GeoDelays for point data.
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if checkdata([3,11]) ne 0 then return
;
num_times=n_elements(PointTime)
;
; Compute apparent star positions
times=abs(PointTime)
stars=strarr(num_times)
for i=0,n_elements(StarId)-1 do stars[Rec0[i]:RecN[i]]=StarId[i]
topostar,times,stars,startable,ra_app,dec_app
;
; Compute uv-coverage
uvw=dblarr(n_elements(vissq[*,0,0,0]), $
	   n_elements(vissq[0,*,0,0]), $
	   n_elements(vissq[0,0,*,0]),3,n_elements(times))
uvw=calcuv(hourangle(ut12gst(times,utc2ut1(times)),ra_app),dec_app,times,uvw)
jndex=where(stars eq 'FKV0000',count)
if count gt 0 then uvw[*,*,*,*,jndex]=0
GeoDelay=stationdelay(uvw)
;
; Reference to reference station
ibr=GenConfig.RefStation-1
for i=0,GenConfig.NumSid-1 do begin
      if i ne ibr then $
      GeoDelay[i,*]= $
      GeoDelay[i,*]-GeoDelay[ibr,*]
endfor
GeoDelay[ibr,*]=0
;
end
