function calchisq,src,cal,beams,chans,ntotl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given star and its calibrator, compute the reduced chisq of the
; deviation of V2 of the former with respect to the latter.
;
; Works only if both overlap in time.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
index1=where(scans.starid eq src)
index2=where(scans.starid eq cal)
;
time1=scans[index1].time
time2=scans[index2].time
;
chisq=0
ntotl=0
;
for i=0,n_elements(beams)-1 do begin
for j=0,n_elements(chans[i,*])-1 do begin
	if chans[i,j] ge 0 then begin
;
	vis1=scans[index1].vissqe(beams[i],chans[i,j],0)
	viserr1=scans[index1].vissqeerr(beams[i],chans[i,j],0)
	vis2=scans[index2].vissqe(beams[i],chans[i,j],0)
	viserr2=scans[index2].vissqeerr(beams[i],chans[i,j],0)
;
	index1e=where(viserr1 gt 0,count1)
	index2e=where(viserr2 gt 0,count2)
	if count1*count2 ne 0 then begin
		vis1e=vis1[index1e]
		viserr1e=viserr1[index1e]
		time1e=time1[index1e]
		vis2e=vis2[index2e]
		viserr2e=viserr2[index2e]
		time2e=time2[index2e]
		chisq1=((vis1e-spline(time2e,vis2e,time1e,1))/ $
			sqrt(viserr1e^2+spline(time2e,viserr2e,time1e,1)^2))^2
		n1=n_elements(chisq1)
		index=where(time1e lt time2e[0],count)
		if count gt 0 then chisq1=chisq1[count:n1-1]
		n1=n_elements(chisq1)
		n1e=n_elements(time1e)
		n2e=n_elements(time2e)
		index=where(time1e gt time2e[n2e-1],count)
		if count gt 0 then chisq1=chisq1[0:n1-1-count]
		n1=n_elements(chisq1)
		chisq2=((vis2e-spline(time1e,vis1e,time2e,1))/ $
			sqrt(viserr2e^2+spline(time1e,viserr1e,time2e,1)^2))^2
		n2=n_elements(chisq2)
		index=where(time2e lt time1e[0],count)
		if count gt 0 then chisq2=chisq2[count:n2-1]
		n2=n_elements(chisq2)
		n1e=n_elements(time1e)
		n2e=n_elements(time2e)
		index=where(time2e gt time1e[n1e-1],count)
		if count gt 0 then chisq2=chisq2[0:n2-1-count]
		n2=n_elements(chisq2)
		chisq=chisq+total(chisq1)
		ntotl=ntotl+n1
	endif
;
	endif
endfor
endfor
;
return,chisq/ntotl
;
end
