function calcpro,baseline,ut
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute projected baseline and return length [m] and pa [degrees, N over E].
; Input baseline, e.g. 'VE0-VG0', ut [hours]
;
; Startable and GeoParms must be loaded.
;
common StarBase,startable,notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
times=ut*3600
num_times=n_elements(times)
;
; Compute apparent star positions
stars=strarr(num_times)+startable[0].starid
topostar,times,stars,startable,ra_app,dec_app
;
; Compute u,v coordinates
;
rad=180/pi_circle
ha=hourangle(ut12gst(times,utc2ut1(times)),ra_app)*(15/rad)
dec=dec_app/rad
;
su=dblarr(num_times,3) & sv=su & sw=su
;
su[*,0]=+sin(ha)
su[*,1]=+cos(ha)
su[*,2]=+0
sv[*,0]=-sin(dec)*cos(ha)
sv[*,1]=+sin(dec)*sin(ha)
sv[*,2]=+cos(dec)
sw[*,0]=+cos(dec)*cos(ha)
sw[*,1]=-cos(dec)*sin(ha)
sw[*,2]=+sin(dec)
;
i=where(stationtable.StationId eq strmid(Baseline,0,3))
j=where(stationtable.StationId eq strmid(Baseline,4,3))
s1c=[stationtable[i].x,stationtable[i].y,stationtable[i].z]
s2c=[stationtable[j].x,stationtable[j].y,stationtable[j].z]
b_xyz=horizon2equatorial(s2c-s1c)
;
um=su[*,0]*b_xyz[0]+su[*,1]*b_xyz[1]+su[*,2]*b_xyz[2]
vm=sv[*,0]*b_xyz[0]+sv[*,1]*b_xyz[1]+sv[*,2]*b_xyz[2]
wm=sw[*,0]*b_xyz[0]+sw[*,1]*b_xyz[1]+sw[*,2]*b_xyz[2]
;
bl=sqrt(um^2+vm^2)
pa=atan(um,vm)*rad
;
return,[[bl],[pa]]
;
end
