pro calcviscal,model=model,multiple=multiple
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes estimated visibilitiy (E, EC) for all averaged calibrators scans.
; Use diameter of calibration star or model visibilities computed before.
;
; Does all nights if more than one is loaded and multiple=1.
;
common Tables,scantable,bgtable,stationtable
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if not keyword_set(multiple) then multiple=0
;
if multiple then nights=geninfo.date else nights=genconfig.date
;
FOR night=0,n_elements(nights)-1 DO BEGIN
;
if n_elements(nights) gt 1 then $
loadnight,GenInfo[night].date, $
	  GeoInfo[night].systemid, $
	  GenInfo[night].configid
;
if checkdata([3,9]) ne 0 then return
;
; Can use the model values instead of estimation based on diameter
if n_elements(model) eq 0 then model=0
;
index=where(abs(scans.time) ge 0,count)
if count eq 0 then begin
	print,'***Error(CALCVISCAL): no valid scan times found!'
	return
endif
;
stars=scantable[index].StarId
;
; Compute calibration factors
if not model then cal=calvis(scans[index].VisSq,scans[index].UVW,stars) $
	     else cal=       scans[index].VisSqM
j=where(cal eq 0,count)
if count gt 0 then cal[j]=1
;
; Calibrate estimated visibilities
;
scans[index].VisSqE=scans[index].VisSq/cal
scans[index].VisSqEErr=scans[index].VisSqErr/cal
scans[index].VisSqEC=scans[index].VisSqC/cal
scans[index].VisSqECErr=scans[index].VisSqCErr/cal
;
; Do the same for the triple amplitudes
scans[index].TripleAmpE=scans[index].TripleAmp
scans[index].TripleAmpEErr=scans[index].TripleAmpErr
scans[index].TripleAmpEC=scans[index].TripleAmpC
scans[index].TripleAmpECErr=scans[index].TripleAmpCErr
for i=0,GenConfig.NumTriple-1 do begin
for j=0,2 do begin
        ob=GenConfig.TripleBeam[j,i]
        bl=GenConfig.TripleBase[j,i]
        ch=GenConfig.TripleChan[0:GenConfig.TripleNumChan[i]-1,j,i]
	scans[index].TripleAmpE(i,ch)=scans[index].TripleAmpE(i,ch) $
		/sqrt(cal[ob,ch,bl,*])
	scans[index].TripleAmpEErr(i,ch)=scans[index].TripleAmpEErr(i,ch) $
		/sqrt(cal[ob,ch,bl,*])
	scans[index].TripleAmpEC(i,ch)=scans[index].TripleAmpEC(i,ch) $
		/sqrt(cal[ob,ch,bl,*])
	scans[index].TripleAmpECErr(i,ch)=scans[index].TripleAmpECErr(i,ch) $
		/sqrt(cal[ob,ch,bl,*])
endfor
endfor
;
if not !qiet then print,'Finished visibility estimation.'
;
if n_elements(bufferinfo) gt 1 and multiple then $
storenight,11L
;
ENDFOR
;
end
