function caldiameter,src,cal,beams=beams,channels=channels
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate src diameter from cal diameter and the ratio of the visibility
; amplitudes. Does not require visibilities to be calibrated.
; Requires time stamps of both src and cal to overlap!
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
!qiet=1
;
; Obtain diameter estimate based on visibility amplitude first
index_src=where(scans.starid eq src and scans.time gt 0,count_src)
index_cal=where(scans.starid eq cal and scans.time gt 0,count_cal)
if count_src*count_cal eq 0 then begin
	print,'***Error[CALDIAMETER]: no data on either star or calibrator!'
	return,0
endif
if n_elements(beams) eq 0 then beems=indgen(GenConfig.NumOutBeam) $
			  else beems=beams-1
chans=intarr(n_elements(beems),max(GenConfig.NumSpecChan))-1
;
for i=0,n_elements(beems)-1 do begin
;
if beems[i] lt 0 or beems[i] ge GenConfig.NumOutBeam then begin
	print,'***Error[CALDIAMETER]: invalid beam selection!'
	return,0
endif
if n_elements(channels) eq 0 then chans[i,0:9]=indgen(10) else begin
	s=size(channels)
	if s[0] le 1 then chans[i,0:total(channels gt 0)-1] $
			 =channels[where(channels gt 0)]-1 $
		     else chans[i,0:total(channels[beems[i],*] gt 0)-1] $
			 =channels[beems[i],where(channels[beems[i],*] gt 0)]-1
endelse
if max(chans) gt max(GenConfig.NumSpecChan)-1 then begin
	print,'***Error[CALDIAMETER]: invalid channel selection!'
	return,0
endif
for j=0,n_elements(chans[i,where(chans[i,*] ge 0)])-1 do begin
;
	v_src=scans[index_src].vissq(beems[i],chans[i,j],0)
	ve_src=scans[index_src].vissqerr(beems[i],chans[i,j],0)
	uvr_src=sqrt(scans[index_src].uvw(beems[i],chans[i,j],0,0)^2 $
	            +scans[index_src].uvw(beems[i],chans[i,j],0,1)^2)/1e6
	v_cal=scans[index_cal].vissqe(beems[i],chans[i,j],0)
	ve_cal=scans[index_cal].vissqeerr(beems[i],chans[i,j],0)
;
	jndex_src=where(ve_src gt 0,count_src)
	jndex_cal=where(ve_cal gt 0,count_cal)
	if count_src*count_cal gt 0 then begin
		d=hb(avg(uvr_src[jndex_src]), $
                     avg(v_src[jndex_src])/avg(v_cal[jndex_cal]))
		if n_elements(d_avg) eq 0 then d_avg=d else d_avg=[d_avg,d]
	endif
;
endfor
endfor
;
if n_elements(d_avg) eq 0 then begin
	print,'***Error[CALDIAMETER]: no valid data!'
	return,-1
endif
diameter=total(d_avg)/n_elements(d_avg)
if not !qiet then print,'Initial estimate: ',diameter
;
; Now do a least-squares adjustment of the diameter
;
i=where(startable.starid eq src)
;
dm=dblarr(3,3)
chifr=0.0005
dd=0.1
;
repeat begin
	startable[i].diameter=diameter
	dm[0,0]=1&dm[0,1]=startable[i].diameter&dm[0,2]=startable[i].diameter^2
	calcviscal
	chisqo=calchisq(src,cal,beems,chans,ntotl)
	startable[i].diameter=diameter-dd
	dm[1,0]=1&dm[1,1]=startable[i].diameter&dm[1,2]=startable[i].diameter^2
	calcviscal
	chisql=calchisq(src,cal,beems,chans,ntotl)
	startable[i].diameter=diameter+dd
	dm[2,0]=1&dm[2,1]=startable[i].diameter&dm[2,2]=startable[i].diameter^2
	calcviscal
	chisqh=calchisq(src,cal,beems,chans,ntotl)
	coeff=invert(dm)#[chisqo,chisql,chisqh]
	diameter=-coeff[1]/(2*coeff[2])
	startable[i].diameter=diameter
	calcviscal
	chisq=calchisq(src,cal,beems,chans,ntotl)
	dd=dd/2
	if not !qiet then print,diameter,chisqo,chisq,ntotl
endrep until 1-chisq/chisqo lt chifr
;
error=sqrt((chisq/ntotl)/coeff[2])
;
!qiet=0
return,diameter
;
end
