pro calfactorplot,triple=triple
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
status=dc_read_free('calfactors.txt',i,v,/col)
;
if n_elements(triple) eq 0 then triple=1
;
if triple then !p.multi=[0,1,2] else !p.multi=0
!p.charsize=1.5
index=where(i eq 2,count)
if count gt 0 then begin
	v2=v[index]
	!x.title='Visibility (squared) calibration factor'
	histograph,v2,min=0.25-0.05/2,max=2.00+0.05/2,binsize=0.05
	f=0.25 & fs=string(f*100,format='(i2)')+'% off: '
	index=where(abs(v2-1) le 0.25,n)
	print,'Percentage of factors less than '+fs,100*float(n)/count
endif
;
if triple then begin
index=where(i eq 3,count)
if count gt 0 then begin
	ta=v[index]
	!x.title='Triple amplitude calibration factor'
	histograph,ta,min=0.25-0.05/2,max=2.00+0.05/2,binsize=0.05
endif
endif
;
end
