pro calibrate,cal_reason,undo
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Calibrate scans using a selection of the calibration entries, given
; by the variable (cal_options.v) and the reason (cal_options.reason).
; Apply only to stars listed in the entry.
; If undo flag is set (1), remove last calibration from data.
; Calibrate only valid scans, not flagged visibilities!
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(cal_reason) eq 0 then begin
	print,'***Error(CALIBRATE): cal_reason undefined!'
	return
endif else if strlen(cal_reason) eq 0 then return
if n_elements(undo) eq 0 then begin
	undo=0
;	print,'***Error(CALIBRATE): undo flag undefined!'
;	return
endif
if undo ne 1 and undo ne 0 then begin
	print,'***Error(CALIBRATE): undo flag has to be 1(uncal) or 0(cal)!'
	return
endif
;
entry_index=where((cal_entries.variable eq cal_options.v) and $
		  (cal_entries.reason eq cal_reason),entry_count)
if entry_count eq 0 then begin
	print,'Warning(CALIBRATE): no entries found for this selection!'
	return
endif
;
; Work on each entry
for n=0,entry_count-1 do begin
	nn=entry_index[n]
	ib=0
	ob=cal_entries[nn].outbeam
	tr=cal_entries[nn].triple
	ch=cal_entries[nn].channel
	bl=cal_entries[nn].baseline
	scan_count=cal_entries[nn].num_scans
	scan_index=cal_entries[nn].scans(0:scan_count-1)
;
	coeffs=cal_entries[nn].coeffs(0:cal_entries[nn].num_coeffs-1)
	sel_indct=cal_entries[nn].indicators(0:cal_entries[nn].num_indct-1)
	sel_funcn=cal_entries[nn].functions(0:cal_entries[nn].num_indct-1, $
					    0:cal_entries[nn].num_funcn-1)
	index=where(strpos(cal_entries[nn].functions(*,0),'S_') ge 0,count)
	if count gt 0 then begin
	   i=where(indicators eq sel_indct[index[0]]) & i=i[0]
	   num_coeffs=n_elements(coeffs)
	   h=set_caldata(i+1,0,0,0,scan_index)
	   first_hour=min(h)-1
	   last_hour=max(h)+1
	   hour_grid=first_hour $
		 	 +findgen(num_coeffs)/(num_coeffs-1) $
			 *(last_hour-first_hour)
	   if n_elements(h) gt 1 then si=sort(h) else si=0
	   R=fltarr(n_elements(h))
	   R[si]=spline(hour_grid,coeffs,h[si])
	endif else begin
	   x_mid=cal_entries[nn].x_mid(0:cal_entries[nn].num_indct-1)
	   x_scl=cal_entries[nn].x_scl(0:cal_entries[nn].num_indct-1)
	   M=calmatrix(scan_index,ob,ch,bl,x_mid,x_scl)
	   if cal_entries[nn].num_coeffs eq 1 then R=M*coeffs[0] $
	  				      else R=M#coeffs
	endelse
	if cal_options.v eq 1 then begin
;	TripleAmp c & c/e
	   if undo then R=1/R
	   v=set_ploterr(29,ib,ob,tr,ch,bl,scan_index)
	   index=where(v gt 0,count)
	   if count gt 0 then begin
	     scans[scan_index[index]].TripleAmpCErr(tr,ch)=v[index]/abs(R[index])
	     v=set_plotdata(29,ib,ob,tr,ch,bl,scan_index)
	     scans[scan_index[index]].TripleAmpC(tr,ch)=v[index]/R[index]
	   endif
	   v=set_ploterr(31,ib,ob,tr,ch,bl,scan_index)
	   index=where(v gt 0,count)
	   if count gt 0 then begin
	     scans[scan_index[index]].TripleAmpECErr(tr,ch)=v[index]/abs(R[index])
	     v=set_plotdata(31,ib,ob,tr,ch,bl,scan_index)
	     scans[scan_index[index]].TripleAmpEC(tr,ch)=v[index]/R[index]
	   endif
	endif else if cal_options.v eq 2 then begin
;	TriplePhase c
	   if undo then R=-R
	   v=set_ploterr(33,ib,ob,tr,ch,bl,scan_index)/RAD
	   index=where(v gt 0,count)
	   if count gt 0 then begin
	     scans[scan_index[index]].TriplePhaseCErr(tr,ch)=v[index]
	     v=set_plotdata(33,ib,ob,tr,ch,bl,scan_index)/RAD
	     scans[scan_index[index]].TriplePhaseC(tr,ch)=v[index]-R[index]
	   endif
	endif else begin
;	VisSq c & c/e
	   if undo then R=1/R
	   v=set_ploterr(25,ib,ob,tr,ch,bl,scan_index)
	   index=where(v gt 0,count)
	   if count gt 0 then begin
	     scans[scan_index[index]].VisSqCErr(ob,ch,bl)=v[index]/abs(R[index])
	     v=set_plotdata(25,ib,ob,tr,ch,bl,scan_index)
	     scans[scan_index[index]].VisSqC(ob,ch,bl)=v[index]/R[index]
	   endif
	   v=set_ploterr(27,ib,ob,tr,ch,bl,scan_index)
	   index=where(v gt 0,count)
	   if count gt 0 then begin
	     scans[scan_index[index]].VisSqECErr(ob,ch,bl)=v[index]/abs(R[index])
	     v=set_plotdata(27,ib,ob,tr,ch,bl,scan_index)
	     scans[scan_index[index]].VisSqEC(ob,ch,bl)=v[index]/R[index]
	   endif
	endelse
;
endfor
;
stars=unique(scans[scan_index].starid)
if undo then print,'Calibration removed from stars: ' $
	else print,'Calibration applied  to  stars: '
print,stars+' ',format='(7a)'
;
end
