pro calibrators2tex,target,aas=aas,calstars=calstars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Based on currently loaded interferometry reduced and calibrated by npoipipe,
; write information on all calibrators with valid data to LaTex. Include
; number of nights a calibrator was used, and the minimum estimated visibility.
; The latter is computed by simulation, i.e. by calling mockdata and calcviscal.
; Prepare in A&A LaTex format (or AAS if aas=1).
;
; Specify calstars to force procedure to use just these as calibrators.
;
common StarBase,StarTable,Notes
common Tables,scantable,bgtable,stationtable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(target) eq 0 then begin
	target=''
	read,target,prompt='Please enter name of target: '
endif
if n_elements(aas) eq 0 then aas=0
;
; Save current startable
startable_bck=startable
;
; Replace all visibility amplitude by unity
mockdata,/init
;
; Compute estimated visibilities given diameter information
calcviscal,/multiple
;
nights=GenInfo.date
arrays=GeoInfo.systemid
confgs=GenInfo.configid
;
nstars=n_elements(startable)
minvis=fltarr(nstars)+1
exist=intarr(nstars)
stars=startable.starid
;
if n_elements(calstars) ne 0 then begin
	startable.bflag='.'
	for i=0,n_elements(calstars)-1 do begin
		j=where(startable.starid eq calstars[i],count)
		if count eq 1 then startable[j].bflag='C'
	endfor
endif
calibrators=startable[where(startable.bflag eq 'C')].starid
used_calibs=strarr(n_elements(calibrators))
;
FOR n=0,n_elements(nights)-1 DO BEGIN
;
night=where(GenInfo.date eq nights[n] $
        and GeoInfo.systemid eq arrays[n] $
        and GenInfo.configid eq confgs[n],count)
if count eq 0 and n_elements(GenInfo.date) eq 1 then night=0
if strupcase(!version.os) ne 'WIN32' $
	and n_elements(bufferinfo) gt 1 then $
	loadnight,GenInfo[night[0]].date, $
		GeoInfo[night[0]].systemid, $
		GenInfo[night[0]].configid
;
; Set bflag to '.' for calibrators always outside of 80 min smoothing interval
t_index=where(scans.starid eq target)
for i=0,n_elements(calibrators)-1 do begin
	c_index=where(scans.starid eq calibrators[i],c_count)
	if c_count gt 0 then begin
	dt=fltarr(c_count)
	for j=0,c_count-1 do $
		dt[j]=min(abs(scans[t_index].time-scans[c_index[j]].time))
	if min(dt) lt 80.0*60.0 then $
		used_calibs[i]='u'
	endif
endfor
;
; Consider only channels 1-8
for i=0,genconfig.numoutbeam-1 do begin
	if genconfig.numspecchan[i] gt 8 then $
	scans[*].vissqcerr(*,8:genconfig.numspecchan[i]-1,*)=-1
endfor
;
if strlen(target) ne 0 then begin
	index=where(scans.starid eq target and scantable.code eq 1,target_count)
	if target_count gt 1 then $
		target_mask=total(scans[index].vissqcerr gt 0,4) $
	else if target_count eq 1 then $
		target_mask=scans[index].vissqcerr gt 0
endif else target_count=0
for i=0,nstars-1 do begin
	index=where(scans.starid eq stars[i] and scantable.code eq 1,count)
	if count gt 0 then begin
		if count gt 1 then $
			calib_mask=total(scans[index].vissqcerr gt 0,4) $
		else 	calib_mask=scans[index].vissqcerr gt 0
		if target_count gt 0 then $
			common_mask=(calib_mask*target_mask) gt 0 else $
			common_mask=calib_mask gt 0
		vissqcerr=scans[index].vissqcerr
		vissqe=scans[index].vissqe
		for j=0,count-1 do vissqcerr[*,*,*,j]= $
				   vissqcerr[*,*,*,j]*common_mask
		index=where(vissqcerr gt 0,count)
		if count gt 0 then begin
			exist[i]=exist[i]+1
			minvis[i]=min([minvis[i],1./max(vissqe[index])])
		endif
	endif
endfor
;
ENDFOR
;
; Set bflag to '.' for calibrators always outside of 80 min smoothing interval
index=where(used_calibs ne 'u',count)
for i=0,count-1 do $
	startable[where(startable.starid eq calibrators[index[i]])].bflag='.'
;
; Reduce startable to observed calibrators
index=where(exist eq 0 or startable.bflag ne 'C')
minvis[index]=0
index=where(minvis ne 0)
exist=exist[index]
minvis=minvis[index]
startable=startable[index]
;
; Get JHK data
starids=startable.starid
rename_starids,'bsc-hdn'
read_catalogs
get_jhk_bsc
;
si=sort(startable.hdn)
startable=startable[si]
starids=starids[si]
minvis=minvis[si]
exist=exist[si]
;
mv=startable.mv
bv=startable.bv
bv_stars
;
s=startable
bv0=s.bv
ebmv=bv-bv0
vmk=s.mv-s.mk
;
openw,unit,target+'_cal.tex',/get_lun
;
IF aas THEN BEGIN
;
printf,unit,'\documentclass[preprint]{/home/chummel/latex/aastex/aastex61}'
printf,unit,'\begin{document}'
printf,unit,'\begin{deluxetable}{llcrrccc}'
printf,unit,'\tabletypesize{\scriptsize}'
printf,unit,'\tablecaption{List of NPOI calibrators used.'+ $
	    ' $\theta_{V-K}$ was not corrected for extinction (see text).'+ $
	    ' $V^2_{\rm min}$ is the minimum estimated calibrator visibility'+ $
	    ' based on the diameter $\theta_{V-K}$}'
printf,unit,'\tablehead{'
printf,unit,'\colhead{HD}&'
printf,unit,'\colhead{Type}&'
printf,unit,'\colhead{$V$}&'
printf,unit,'\colhead{$V-K$}&'
printf,unit,'\colhead{$E(B-V)$}&'
printf,unit,'\colhead{$\theta_{V-K}$}&'
printf,unit,'\colhead{$V^2_{\rm min}$}&'
printf,unit,'\colhead{Nights}'
printf,unit,'}'
printf,unit,'\startdata'
;
ENDIF ELSE BEGIN
;
printf,unit,'\documentclass[twocolumn]{/home/chummel/latex/aa-package/aa}'
printf,unit,'\usepackage{graphicx}'
printf,unit,'\usepackage{txfonts}'
printf,unit,'\usepackage{natbib}'
printf,unit,'\usepackage{upgreek}'
printf,unit,'\usepackage{url}'
printf,unit,'\begin{document}'
printf,unit,'\begin{table}'
printf,unit,'\caption{NPOI observations of '+target+' }'
printf,unit,'\label{npoilog}'
printf,unit,'\begin{tabular}{llcrrccc}'
printf,unit,'\hline'
printf,unit,'\hline'
printf,unit,'List of NPOI calibrators used for '+target+'\\'
printf,unit,'HD&Type&$V$&$V-K$&$E(B-V)$&$\theta_{V-K}$&$V^2_{\rm min}$&Nights\\'
printf,unit,'  &    &   &     &        &         [mas]&               &      \\'
printf,unit,'\hline'
;
ENDELSE
;
for i=0,n_elements(s)-1 do begin
;	printf,unit,'HD ',s(i).hdn,s(i).spectrum, $
;	format='(a3,i6,"&",a,"&",f5.2,"&",f5.2,"&",f5.2,"&",f4.2,"&",f4.2,"&",i2,"\\")
	printf,unit,starids[i],s[i].spectrum, $
		mv[i],vmk[i],ebmv[i],s[i].diameter,minvis[i],exist[i], $
	format='(a,"&",a,"&",f5.2,"&",f5.2,"&",f5.2,"&",f4.2,"&",f4.2,"&",i2,"\\")'
endfor
;
IF aas THEN BEGIN
	printf,unit,'\enddata'
	printf,unit,'\end{deluxetable}'
ENDIF ELSE BEGIN
	printf,unit,'\hline'
	printf,unit,'\end{tabular}'
	printf,unit,'\end{table}'
ENDELSE
printf,unit,'\end{document}'
;
free_lun,unit
;
; Restore startable
startable=startable_bck
;
end
