function calmatrix,scan_index,outbeam,channel,baseline,x_mid,x_scl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the part of the calibration design matrix that corresponds to the
; selected data, as reflected in scan_index.
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
;
num_indicators=n_elements(sel_indct)
num_functions=intarr(num_indicators)
num_terms=1
for i=0,num_indicators-1 do begin
	index=where(sel_funcn[i,*] ne '',count)
	num_functions[i]=count
	num_terms=num_terms*count
endfor
;
scan_count=n_elements(scan_index)
M=fltarr(scan_count,num_terms,/nozero)
;
term_index=intarr(num_indicators)
for i=0,num_terms-1 do begin
	M[*,i]=1
	for j=0,num_indicators-1 do begin
		index=where(indicators eq sel_indct[j])+1
		x=set_caldata(index[0],outbeam,channel,baseline,scan_index)
		M[*,i]=M[*,i] $
		      *evalfunction(sel_funcn[j,term_index[j]],x, $
					x_mid[j],x_scl[j])
	endfor
;
	if i lt num_terms-1 then begin
		j=num_indicators
		repeat begin
			j=j-1
			term_index[j]=term_index[j]+1
		endrep until term_index[j] lt num_functions[j]
		if (j+1) le (num_indicators-1) then $
			term_index[j+1:num_indicators-1]=0
	endif
endfor
;
return,M
;
end
