function caluddiam,star,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given star, find limb-darkened diameter (LD) in star table,
; and compute uniform disk diameter (UD) for given wavelength lambda [nm].
;
common StarBase,StarTable,Notes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
LD=0
index=where(StarTable.starid eq star,count)
if count gt 0 then begin
	A0=StarTable[index].a0
	A1=StarTable[index].a1
	A2=StarTable[index].a2
	LD=StarTable[index].diameter
endif
if count eq 0 or min(LD) eq 0 then begin
	print,'Error(CALUDDIAM): diameter = 0 or not found in table!'
	return,-1
endif
factor=(pi_circle^2)/(180L*3600L*1000L)
if abs(A1) ge 0.01 then begin
;	Logarithmic polynomial fit coefficients
	x=alog10(lambda)
	u_lambda=10^(A0+A1*x+A2*x^2)
endif
if abs(A1) lt 0.01 then begin
;	Linear polynomic fit coefficients
	x=lambda
	u_lambda=A0+A1*x+A2*x^2
endif
;
return,LD/limbfactor(u_lambda)
;
end
