function calvis,vis,uvw,stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate squared visibilities for calibrator stars.
; Note the units:
; u,v,w	[lambda]
; LD 	[mas]
;
; LD is the limb darkened disk diameter taken from startable.
; Coefficients A0, A1, and A2 available from startable are
; used to compute the limb darkening coeeficients.
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
vis_cal=vis*0+1
s=size(vis_cal)
;
num_scans=n_elements(stars)
LD=fltarr(num_scans)
A0=fltarr(num_scans)
A1=fltarr(num_scans)
A2=fltarr(num_scans)
for i=0,n_elements(StarTable)-1 do begin
	index=where(stars eq StarTable[i].starid,count)
	if count gt 0 then begin
		A0[index]=StarTable[i].a0
		A1[index]=StarTable[i].a1
		A2[index]=StarTable[i].a2
		LD[index]=StarTable[i].diameter
	endif
endfor
if min(LD) eq 0 then $
	print,'Warning(VISEST): some diameters = 0 or not found in table!'
;
factor=(pi_circle^2)/(180L*3600L*1000L)
;
for ob=0,GenConfig.NumOutBeam-1 do begin
for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
	lambda=GenConfig.Wavelength[ch,ob]*1.d9 	; lambda in nm
	u_lambda=fltarr(num_scans)
	index=where(abs(A1) ge 0.01,count)
	if count gt 0 then begin
;		Logarithmic polynomial fit coefficients
		x=alog10(lambda)
		u_lambda[index]=10^(A0+A1*x+A2*x^2)
	endif
	index=where(abs(A1) lt 0.01,count)
	if count gt 0 then begin
;		Linear polynomic fit coefficients
		x=lambda
		u_lambda[index]=A0+A1*x+A2*x^2
	endif
        alpha=1-u_lambda
        beeta=u_lambda
;	LD=sqrt(((1-u_lambda/3)/(1-7*u_lambda/15)))*UD
	LD_zero=where(LD eq 0,LD_zero_count)
	if LD_zero_count gt 0 then LD[LD_zero]=1
	for bl=0,GenConfig.NumBaseline[ob]-1 do begin
		arg=factor*sqrt(uvw[ob,ch,bl,0,*]^2+uvw[ob,ch,bl,1,*]^2)*LD
		UV_zero=where(arg eq 0,UV_zero_count)
		if UV_zero_count gt 0 then arg[UV_zero]=1
		cal=((alpha*beselj(arg,1)/arg+beeta*sqrt(pi_circle/2)* $
                      sqrt(2/(pi_circle*arg))*(sin(arg)/arg-cos(arg))/ $
                      sqrt(arg*arg*arg))/(alpha/2+beeta/3))^2
		if LD_zero_count gt 0 then cal[LD_zero]=1
		if LD_zero_count gt 0 then LD[LD_zero]=0
		if UV_zero_count gt 0 then cal[UV_zero]=1
		if s[0] eq 1 then vis_cal[*]=cal else vis_cal[ob,ch,bl,*]=cal
	endfor
endfor
endfor
;
return,vis_cal
;
end
