function catseyedelay,feed_angle,cx,cy,cz,ha,dec,offset,cxe,cye,cze,e
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return change in optical path due to change in catseye position xyz.
; Right-handed coordinate system, X east, Y north, Z up.
; Input HA is in hours, DEC in degrees.
;
; The formula works differently for corrections of stellar and white light
; observations. For stellar light, the component of the pivot motion in the
; direction of the mirror normal is computed, then multiplied with the
; projection of the mirror normal onto the feed (or star) direction. The
; optical path change, which stellar light suffers as a consequence of
; the motion of the pivot and which was compensated with the delay lines,
; is twice that value.
;
; White light measurements are used to monitor the optical from the siderostats
; through the feed system to the beam combiner. The autocollimation setup is
; that of a Michelson interferometer. If the siderostat mirror moves by a
; distance x, then the delay line moves by x/2 to keep the path length the same.
; The optical path change in the delay line measured by the metrology is twice
; the physical motion of the delay cart and is equal to x. In other words, the
; metrology delay changes are equal to the physical motion of the siderostat,
; or path length changes in the feed system. Therefore, the optical path change
; due to pivot motion as measured by the siderostat metrology and derived in
; the previous paragraph has to be divided by 2 before applying it to the
; white light delay measurements. The corrected white light delays, as
; measures of the optical path changes solely due to feed system motions,
; can then be directly applied to the stellar delays.
;
; Note that the calling routine has to divide the optical path by 2
; for white light measurements in order to convert them to single-pass
; optical paths.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
rad=180/pi_circle
ha_r=ha*(15/rad)
dec_r=dec/rad
;
; Feed vector, originating at siderostat mirror
feed_az=feed_angle[0]/rad; about 88.5 deg, i.e. pointing towards West
feed_el=feed_angle[1]/rad; about 18.5 deg, i.e. beam rises towards NAT mirror
feed_x=-sin(feed_az)*cos(feed_el)
feed_y=+cos(feed_az)*cos(feed_el)
feed_z=+sin(feed_el)
;
; Star vector
x=-cos(dec_r)*sin(ha_r)
y=+sin(dec_r)*cos(GeoParms.Latitude/rad) $
  -cos(dec_r)*sin(GeoParms.Latitude/rad)*cos(ha_r)
z=+cos(dec_r)*cos(GeoParms.Latitude/rad)*cos(ha_r) $
  +sin(dec_r)*sin(GeoParms.Latitude/rad)
;
; Mirror normal
m1=(feed_x+x)
m2=(feed_y+y)
m3=(feed_z+z)
length=sqrt(m1^2+m2^2+m3^2)
m1=m1/length
m2=m2/length
m3=m3/length
;
if n_elements(cze) ne 0 then $
	e=2*(m1*x+m2*y+m3*z)*sqrt((cxe*m1)^2+(cye*m2)^2+(cze*m3)^2)
index=where(cxe le 0 or cye le 0 or cze le 0,count)
if count gt 0 then e[index]=-e[index]
;
; A note on the sign: if additional optical path is introduced through
; motion of the pivot away from the feed, the returned delay is negative,
; indicating that the corresponding delay line moved towards the front,
; i.e. removing optical path.
;
return,2*(cx*m1+cy*m2+cz*m3)*(m1*x+m2*y+m3*z)+2*offset*(m1*x+m2*y+m3*z)
;
end
