function channelindex,specid,datum,bad=bad
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function returns indices of good or bad channels based on
; a small data base of NPOI channel performances.
;
; Should also apply to H_alpha setups
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(specid) eq 0 then return,-1
if n_elements(datum) eq 0 then datum=date
if n_elements(bad) eq 0 then bad=0 else bad=bad gt 0
;
parsedate,date,y,m,d
jd=julian(y,m,d)
;
id=strmid(specid,strlen(specid)-1,1)
case id of
'1':	begin
;	Bad laser channel, bad blue response
	if jd lt julian(2000,1,1) then begin
		chg=stringparse('1-10,12-20')
		chb=stringparse('11,21-32')
;	Broken fiber
	endif else if jd lt julian(2001,9,28)then begin
		chg=stringparse('1-10,13-20')
		chb=stringparse('11,12,21-32')
;	6-way
	endif else if jd lt julian(2002,5,11)then begin
		chg=stringparse('1-10,13-16')
		chb=stringparse('11,12')
;	Spectrometer recabled to remove laser channel,
;	but broken fiber (jumper?) remains, is now channel 11
	endif else begin
		chg=stringparse('1-10,12-16')
		chb=11
	endelse
	end
'2':	begin
	if jd lt julian(2001,9,28)then begin
		chg=stringparse('1-10,12-20')
		chb=stringparse('11,21-32')
;	6-way
	endif else if jd lt julian(2002,5,11)then begin
		chg=stringparse('1-10,12-16')
		chb=11
	endif else if jd lt julian(2010,2,01)then begin
;		Channels all OK on 2002-05-20
		chg=stringparse('1-16')
		chb=0
	endif else begin
		chg=stringparse('1-10,12-16')
;		Still bad, looking at data from 2011-10 and 2012-03
		chb=11
	endelse
	end
'3':	begin
	if jd lt julian(2001,9,28)then begin
		chg=stringparse('1-10,12-20')
		chb=stringparse('11,21-32')
;	6-way
	endif else if jd lt julian(2002,5,11)then begin
		chg=stringparse('1-10,12-16')
		chb=11
;	Data from October 2003 have bad channel 11
	endif else if jd le julian(2003,10,18)then begin
		chg=stringparse('1-10,12-16')
		chb=11
	endif else if jd lt julian(2010,2,01)then begin
		chg=stringparse('1-16')
		chb=0
	endif else begin
;		Channel 4 has intermittend elevated background
;		chg=stringparse('1-3,5-10,12-16')
		chg=stringparse('1-3,5-16')
;		chb=stringparse('4,11')
		chb=stringparse('4')
	endelse
	end
endcase
;
if bad then return,chb else return,chg
;
end
