pro check_oifits,oiarray,oitarget,oiwavelength, $
	oivis1=oivis,oivis2=oivis2,oit3=oit3,oiflux=oiflux
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fix problems with OIFITS files written by various softwares.
; Currently, missing or broken oiarray tables are fixed in
; get_oifits.
;
; Fix VLTI OB definition errors
if n_elements(oivis2) gt 0 then begin
if oivis2[0].date_obs eq '2024-01-08T07:40:29'  $
	and strpos(oivis2[0].insname,'GRAVITY') ge 0 $
	and oitarget[0].target eq 'HD4660' then begin
		oitarget[0].target = 'HDN094660'
endif
if oivis2[0].date_obs eq '2024-03-10T03:05:19'  $
	and strpos(oivis2[0].insname,'GRAVITY') ge 0 $
	and oitarget[0].target eq 'HD4660' then begin
		oitarget[0].target = 'HDN094660'
endif
if oivis2[0].date_obs eq '2025-02-05T05:43:14'  $
	and strpos(oivis2[0].insname,'GRAVITY') ge 0 $
	and oitarget[0].target eq 'HD9466' then begin
		oitarget[0].target = 'HDN094660'
endif
endif
;
; Make sure StarTable only lists StarIDs for which data are available
flag=0
if n_elements(oivis2) gt 0 then begin
	oitarget_ids=intarr(n_elements(oitarget.target_id))+1
	for i=0,n_elements(oitarget.target_id)-1 do begin
		index=where(oivis2.target_id eq oitarget[i].target_id,n)
		if n eq 0 then oitarget_ids[i]=0
	endfor
	oitarget=oitarget[where(oitarget_ids eq 1)]
endif else if n_elements(oivis) gt 0 then begin
	oitarget_ids=intarr(n_elements(oitarget.target_id))+1
	for i=0,n_elements(oitarget.target_id)-1 do begin
		index=where(oivis.target_id eq oitarget[i].target_id,n)
		if n eq 0 then oitarget_ids[i]=0
	endfor
	oitarget=oitarget[where(oitarget_ids eq 1)]
endif else if n_elements(oit3) gt 0 then begin
	oitarget_ids=intarr(n_elements(oitarget.target_id))+1
	for i=0,n_elements(oitarget.target_id)-1 do begin
		index=where(oit3.target_id eq oitarget[i].target_id,n)
		if n eq 0 then oitarget_ids[i]=0
	endfor
	oitarget=oitarget[where(oitarget_ids eq 1)]
endif else if n_elements(oiflux) gt 0 then begin
	oitarget_ids=intarr(n_elements(oitarget.target_id))+1
	for i=0,n_elements(oitarget.target_id)-1 do begin
		index=where(oiflux.target_id eq oitarget[i].target_id,n)
		if n eq 0 then oitarget_ids[i]=0
	endfor
	oitarget=oitarget[where(oitarget_ids eq 1)]
endif
;
; Make sure target IDs start with 1 and are consecutive
if max(oitarget.target_id) gt n_elements(oitarget) then begin
	j=max(oitarget.target_id)
	num_target=n_elements(oitarget)
	old_ids=oitarget.target_id
	new_ids=indgen(num_target)+1
	for i=1,num_target do begin
		if n_elements(oivis2) ne 0 then begin
			index=where(oivis2.target_id eq oitarget[i-1].target_id)
			oivis2[index].target_id=i+j
		endif
		if n_elements(oivis) ne 0 then begin
			index=where(oivis.target_id eq oitarget[i-1].target_id)
			oivis[index].target_id=i+j
		endif
		if n_elements(oit3) ne 0 then begin
			index=where(oit3.target_id eq oitarget[i-1].target_id)
			oit3[index].target_id=i+j
		endif
		if n_elements(oiflux) ne 0 then begin
			index=where(oiflux.target_id eq oitarget[i-1].target_id)
			oiflux[index].target_id=i+j
		endif
	endfor
	if n_elements(oivis2) ne 0 then oivis2.target_id= $
					oivis2.target_id-j
	if n_elements(oivis) ne 0 then oivis.target_id= $
					oivis.target_id-j
	if n_elements(oit3) ne 0 then oit3.target_id= $
					oit3.target_id-j
	if n_elements(oiflux) ne 0 then oiflux.target_id= $
					oiflux.target_id-j
	oitarget.target_id=new_ids
endif
;
; Target IDs must conform to OYSTER scheme
for i=0,n_elements(oitarget)-1 do begin
	r=strsplit(oitarget[i].target,'HIP',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='HIP'+string(r,format='(i6.6)')
	if isnumeric(r) then continue
	r=strsplit(oitarget[i].target,'HIC',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='HIC'+string(r,format='(i6.6)')
	if isnumeric(r) then continue
	r=strsplit(oitarget[i].target,'HDN',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='HDN'+string(r,format='(i6.6)')
	if isnumeric(r) then continue
	r=strsplit(oitarget[i].target,'SAO',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='SAO'+string(r,format='(i6.6)')
	if isnumeric(r) then continue
	r=strsplit(oitarget[i].target,'FKV',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='FKV'+string(r,format='(i4.4)')
	if isnumeric(r) then continue
	r=strsplit(oitarget[i].target,'BSC',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='BSC'+string(r,format='(i4.4)')
	r=strsplit(oitarget[i].target,'FLN',/extract) & r=r[0]
	if isnumeric(r) then oitarget[i].target='FLN'+string(r,format='(i4.4)')
	if isnumeric(r) then continue
	r=cri_vlti(oitarget[i].target)
	if strlen(r) eq 0 then begin
		print,'Error (check_oifits): could not find ID for target ', $
			oitarget[i].target,' in catalogs!'
		print,'Please add HD ID in oyster/starbase/vlti.hdn.'
		return
	endif else oitarget[i].target=r
endfor
;
; NaNs happened in oivis2
if n_elements(oivis2) ne 0 then begin
;	index=where(finite(*oivis2.vis2err) eq 0,count)
;	index=where(finite((*oivis2.vis2err) ne 0)
;	if count gt 0 then oivis2.vis2err(index)=-1
endif
;
; Fix issues with GRAVITY pipeline products
fixed=0
if n_elements(oiflux) ne 0 then begin
;	Remove time stamp jitter within P1 and P2 series
;	P1/P2 are the two polarisations in SPLIT mode
	index=where(strpos(oiflux.insname,'GRAVITY_SC_P1') ge 0,count)
	if count gt 0 then oiflux[index].time=mean(oiflux[index].time)
	if count gt 0 then oiflux[index].mjd=mean(oiflux[index].mjd)
	index=where(strpos(oiflux.insname,'GRAVITY_SC_P2') ge 0,count)
	if count gt 0 then oiflux[index].time=mean(oiflux[index].time)
	if count gt 0 then oiflux[index].mjd=mean(oiflux[index].mjd)
	index=where(strpos(oiflux.insname,'GRAVITY_FT_P1') ge 0,count)
	if count gt 0 then oiflux[index].time=mean(oiflux[index].time)
	if count gt 0 then oiflux[index].mjd=mean(oiflux[index].mjd)
	index=where(strpos(oiflux.insname,'GRAVITY_FT_P2') ge 0,count)
	if count gt 0 then oiflux[index].time=mean(oiflux[index].time)
	if count gt 0 then oiflux[index].mjd=mean(oiflux[index].mjd)
;
; 	Pipeline adds _1,2,... for "extra" scans, are not new spectrometers
	index=where(strpos(oiflux.insname,'GRAVITY_SC_') ge 0,count)
	if count gt 0 then oiflux[index].insname='GRAVITY_SC'
	index=where(strpos(oiflux.insname,'GRAVITY_FT_') ge 0,count)
	if count ge 1 then begin
	if count gt 0 then oiflux[index].insname='GRAVITY_FT'
	endif
;
;	Remove time difference between SC and FT
	index_sc=where(strpos(oiflux.insname,'GRAVITY_SC') ge 0,count)
	index_ft=where(strpos(oiflux.insname,'GRAVITY_FT') ge 0,count)
	if count ge 1 then begin
		td=median(oiflux[index_sc].time-oiflux[index_ft].time)
		if td lt 0.1 then begin
			oiflux[index_ft]=oiflux[index_sc]
			fixed=1
		endif
	endif
endif
if n_elements(oivis2) ne 0 then begin
;	Remove time stamp jitter within P1 and P2 series
	index=where(strpos(oivis2.insname,'GRAVITY_SC_P1') ge 0,count)
	if count gt 0 then oivis2[index].time=mean(oivis2[index].time)
	if count gt 0 then oivis2[index].mjd=mean(oivis2[index].mjd)
	index=where(strpos(oivis2.insname,'GRAVITY_SC_P2') ge 0,count)
	if count gt 0 then oivis2[index].time=mean(oivis2[index].time)
	if count gt 0 then oivis2[index].mjd=mean(oivis2[index].mjd)
	index=where(strpos(oivis2.insname,'GRAVITY_FT_P1') ge 0,count)
	if count gt 0 then oivis2[index].time=mean(oivis2[index].time)
	if count gt 0 then oivis2[index].mjd=mean(oivis2[index].mjd)
	index=where(strpos(oivis2.insname,'GRAVITY_FT_P2') ge 0,count)
	if count gt 0 then oivis2[index].time=mean(oivis2[index].time)
	if count gt 0 then oivis2[index].mjd=mean(oivis2[index].mjd)
;
; 	Pipeline adds _1,2,... for "extra" scans, are not new spectrometers
	index=where(strpos(oivis2.insname,'GRAVITY_SC_') ge 0,count)
	if count gt 0 then oivis2[index].insname='GRAVITY_SC'
	index=where(strpos(oivis2.insname,'GRAVITY_FT_') ge 0,count)
	if count gt 0 then oivis2[index].insname='GRAVITY_FT'
;
;	Remove time difference between SC and FT
	index_sc=where(strpos(oivis2.insname,'GRAVITY_SC') ge 0,count)
	index_ft=where(strpos(oivis2.insname,'GRAVITY_FT') ge 0,count)
	if count ge 1 then begin
		td=median(oivis2[index_sc].time-oivis2[index_ft].time)
		if td lt 0.1 then begin
			oivis2[index_ft]=oivis2[index_sc]
			fixed=1
		endif
	endif
;
endif
if n_elements(oivis) ne 0 then begin
;	Remove time stamp jitter within P1 and P2 series
	index=where(strpos(oivis.insname,'GRAVITY_SC_P1') ge 0,count)
	if count gt 0 then oivis[index].time=mean(oivis[index].time)
	if count gt 0 then oivis[index].mjd=mean(oivis[index].mjd)
	index=where(strpos(oivis.insname,'GRAVITY_SC_P2') ge 0,count)
	if count gt 0 then oivis[index].time=mean(oivis[index].time)
	if count gt 0 then oivis[index].mjd=mean(oivis[index].mjd)
	index=where(strpos(oivis.insname,'GRAVITY_FT_P1') ge 0,count)
	if count gt 0 then oivis[index].time=mean(oivis[index].time)
	if count gt 0 then oivis[index].mjd=mean(oivis[index].mjd)
	index=where(strpos(oivis.insname,'GRAVITY_FT_P2') ge 0,count)
	if count gt 0 then oivis[index].time=mean(oivis[index].time)
	if count gt 0 then oivis[index].mjd=mean(oivis[index].mjd)
;
; 	Pipeline adds _1,2,... for "extra" scans, are not new spectrometers
	index=where(strpos(oivis.insname,'GRAVITY_SC_') ge 0,count)
	if count gt 0 then oivis[index].insname='GRAVITY_SC'
	index=where(strpos(oivis.insname,'GRAVITY_FT_') ge 0,count)
	if count gt 0 then oivis[index].insname='GRAVITY_FT'
;
;	Remove time difference between SC and FT
	index_sc=where(strpos(oivis.insname,'GRAVITY_SC') ge 0,count)
	index_ft=where(strpos(oivis.insname,'GRAVITY_FT') ge 0,count)
	if count ge 1 then begin
		td=median(oivis[index_sc].time-oivis[index_ft].time)
		if td lt 0.1 then begin
			oivis[index_ft]=oivis[index_sc]
			fixed=1
		endif
	endif
;
endif
if n_elements(oit3) ne 0 then begin
;	Remove time stamp jitter within P1 and P2 series
	index=where(strpos(oit3.insname,'GRAVITY_SC_P1') ge 0,count)
	if count gt 0 then oit3[index].time=mean(oit3[index].time)
	if count gt 0 then oit3[index].mjd=mean(oit3[index].mjd)
	index=where(strpos(oit3.insname,'GRAVITY_SC_P2') ge 0,count)
	if count gt 0 then oit3[index].time=mean(oit3[index].time)
	if count gt 0 then oit3[index].mjd=mean(oit3[index].mjd)
	index=where(strpos(oit3.insname,'GRAVITY_FT_P1') ge 0,count)
	if count gt 0 then oit3[index].time=mean(oit3[index].time)
	if count gt 0 then oit3[index].mjd=mean(oit3[index].mjd)
	index=where(strpos(oit3.insname,'GRAVITY_FT_P2') ge 0,count)
	if count gt 0 then oit3[index].time=mean(oit3[index].time)
	if count gt 0 then oit3[index].mjd=mean(oit3[index].mjd)
;
; 	Pipeline adds _1,2,... for "extra" scans, are not new spectrometers
	index=where(strpos(oit3.insname,'GRAVITY_SC_') ge 0,count)
	if count gt 0 then oit3[index].insname='GRAVITY_SC'
	index=where(strpos(oit3.insname,'GRAVITY_FT_') ge 0,count)
	if count gt 0 then oit3[index].insname='GRAVITY_FT'
;
;	Remove time difference between SC and FT
	index_sc=where(strpos(oit3.insname,'GRAVITY_SC') ge 0,count)
	index_ft=where(strpos(oit3.insname,'GRAVITY_FT') ge 0,count)
	if count ge 1 then begin
		td=median(oiflux[index_sc].time-oiflux[index_ft].time)
		if td lt 0.1 then begin
			oit3[index_ft]=oit3[index_sc]
			fixed=1
		endif
	endif
endif
if fixed then print,'Fixed GRAVITY time stamp jitter and scans data structure!'
;
; 	Update OIWAVELENGTH table
	index=where(strpos(oiwavelength.insname,'GRAVITY_SC_P1') ge 0,count1)
	if count gt 0 then oiwavelength[index].insname='GRAVITY_SC'
	index=where(strpos(oiwavelength.insname,'GRAVITY_SC_P2') ge 0,count2)
	if count gt 0 then oiwavelength[index].insname='GRAVITY_SC'
	index=where(strpos(oiwavelength.insname,'GRAVITY_FT_P1') ge 0,count3)
	if count gt 0 then oiwavelength[index].insname='GRAVITY_FT'
	index=where(strpos(oiwavelength.insname,'GRAVITY_FT_P2') ge 0,count4)
	if count gt 0 then oiwavelength[index].insname='GRAVITY_FT'
	oiwavelength=oiwavelength[uniq(oiwavelength.insname)]
	if count1+count2+count3+count4 gt 0 then $
		print,'Ignored GRAVITY P1/P2 split mode assignments!'
; 	Remove FT data from GRAVITY dual observations
	index=where(strpos(oiwavelength.insname,'GRAVITY_SC') ge 0,count)
	if count gt 0 then oiwavelength=oiwavelength[index]
	index=where(strpos(oivis2.insname,'GRAVITY_SC') ge 0,count)
	if count gt 0 then begin
		target_id=unique(oivis2[index].target_id)
		oivis2=oivis2[index]
	endif
	if n_elements(oivis2) ne 0 then $
	index=where(strpos(oivis2.insname,'GRAVITY_SC') ge 0,count) else count=0
	if count gt 0 then oivis2=oivis2[index]
	if n_elements(oivis) ne 0 then $
	index=where(strpos(oivis.insname,'GRAVITY_SC') ge 0,count) else count=0
	if count gt 0 then oivis=oivis[index]
	if n_elements(oit3) ne 0 then $
	index=where(strpos(oit3.insname,'GRAVITY_SC') ge 0,count) else count=0
	if count gt 0 then oit3=oit3[index]
	if n_elements(oiflux) ne 0 then $
	index=where(strpos(oiflux.insname,'GRAVITY_SC') ge 0,count) else count=0
	if count gt 0 then oiflux=oiflux[index]
;
; Fix issue with merge_oidata: oiarray contains duplicates
oi=uniq(oiarray.sta_index,sort(oiarray.sta_index))
if n_elements(oi) lt n_elements(oiarray) then $
	oiarray=oiarray[oi]
;
; Fix issues with Beauty contest data
;
dates=''
arrnames=''
insnames=''
if n_elements(oivis2) ne 0 then begin
	dates=unique(strmid(oivis2.date_obs,0,10))
	arrnames=unique(strtrim(oivis2.arrname,2))
	insnames=unique(strtrim(oivis2.insname,2))
endif
;
; ...check that int_time > 0 if flag=FALSE (2014 HgMn PIONIER data)
false=byte('F') & false=false[0]
for i=0,n_elements(oivis)-1 do begin
	eindex=where(byte(*oivis[i].flag) eq false,ecount)
	if ecount gt 0 and oivis[i].int_time eq 0 then oivis[i].int_time=1
endfor
for i=0,n_elements(oivis2)-1 do begin
	eindex=where(byte(*oivis2[i].flag) eq false,ecount)
	if ecount gt 0 and oivis2[i].int_time eq 0 then oivis2[i].int_time=1
endfor
for i=0,n_elements(oit3)-1 do begin
	eindex=where(byte(*oit3[i].flag) eq false,ecount)
	if ecount gt 0 and oit3[i].int_time eq 0 then oit3[i].int_time=1
endfor
for i=0,n_elements(oiflux)-1 do begin
	eindex=where(byte(*oiflux[i].flag) eq false,ecount)
	if ecount gt 0 and oiflux[i].int_time eq 0 then oiflux[i].int_time=1
endfor
;
; ...Array name
fixed=0
if oiarray[0].arrname eq 'NPOI_2004-04-12' then begin
	oiarray.arrname='NPOI'
	fixed=1
endif
if oiarray[0].arrname eq 'NPOI_2004-07-19' then begin
	oiarray.arrname='NPOI'
	fixed=1
endif
if fixed then print,'Warning: Beauty contest data fixed (NPOI)!'
;
; ...CHARA stations need to have 3 letters
for i=0,n_elements(oiarray)-1 do begin
	if strpos(oiarray[i].arrname,'CHARA') eq 0 then begin
		tel_arm=strmid(oiarray[i].tel_name,0,1)
		sta_num=strmid(oiarray[i].tel_name,1,1)
		oiarray[i].tel_name=tel_arm+'0'+sta_num
		sta_arm=strmid(oiarray[i].sta_name,0,1)
		sta_num=strmid(oiarray[i].sta_name,1,1)
		oiarray[i].sta_name=sta_arm+'0'+sta_num
	endif
endfor
;
; ...missing keywords
fixed=0
tags=tag_names(oitarget)
for i=0,n_tags(oitarget)-1 do begin
	if tags[i] eq 'SYSVEL' then begin
		j=where(finite(oitarget.sysvel) eq 0,count)
		if count gt 0 then oitarget[j].sysvel=0
		if count gt 0 then fixed=1
	endif
	if tags[i] eq 'PMRA' then begin
		j=where(finite(oitarget.pmra) eq 0,count)
		if count gt 0 then oitarget[j].pmra=0
		if count gt 0 then fixed=1
	endif
	if tags[i] eq 'PMRA_ERR' then begin
		j=where(finite(oitarget.pmra_err) eq 0,count)
		if count gt 0 then oitarget[j].pmra_err=0
		if count gt 0 then fixed=1
	endif
	if tags[i] eq 'PMDEC' then begin
		j=where(finite(oitarget.pmdec) eq 0,count)
		if count gt 0 then oitarget[j].pmdec=0
		if count gt 0 then fixed=1
	endif
	if tags[i] eq 'PMDEC_ERR' then begin
		j=where(finite(oitarget.pmdec_err) eq 0,count)
		if count gt 0 then oitarget[j].pmdec_err=0
		if count gt 0 then fixed=1
	endif
	if tags[i] eq 'PARALLAX' then begin
		j=where(finite(oitarget.parallax) eq 0,count)
		if count gt 0 then oitarget[j].parallax=0
		if count gt 0 then fixed=1
	endif
	if tags[i] eq 'PARA_ERR' then begin
		j=where(finite(oitarget.para_err) eq 0,count)
		if count gt 0 then oitarget[j].para_err=0
		if count gt 0 then fixed=1
	endif
endfor
if fixed then print,'Warning: missing OI_TARGET header keywords added!'
;
; ...issue with JWST data (written by Joel):
; 	each epoch is in a new extension
fixed=0
if dates[0] eq '2021-10-20' and arrnames[0] eq 'JWST_SIM' then begin
	print,'Fixing JWST_SIM MASKING data...'
	arrname='JWST_SIM'
	apertures=system_config(arrname,'STATIONS')
	ipos=strlen(shortest(insnames))
	oivis2.arrname=arrname
	oiarray.tel_name=apertures
	oiarray.sta_name=apertures
	oivis2.insname='7Holes'+strmid(oivis2.insname,ipos,3)
	oit3.arrname=arrname
	oit3.insname='7Holes'+strmid(oit3.insname,ipos,3)
	if n_elements(oivis) ne 0 then begin
		oivis.arrname=arrname
		oivis.insname='7Holes'+strmid(oivis.insname,ipos,3)
	endif
	oiwavelength.insname='7Holes'
;	Merge identical wavelength tables
	oiwavelength=oiwavelength[0]
	*oiwavelength[0].eff_band=1e-6
	fixed=1
endif
if fixed then print,'Warning: SAM data from JWST_SIM fixed!'
;
; ...issue with SAM data from T-ReCS (written by John):
; 	each epoch is in a new extension
fixed=0
if dates[0] eq '2005-01-03' and arrnames[0] eq 'KECK-1_MASKING' then begin
	print,'Fixing KECK-1_MASKING data...'
	arrname='T-ReCS'
	apertures=system_config(arrname,'STATIONS')
	ipos=strlen(shortest(insnames))
	oivis2.arrname=arrname
	oivis2.insname='7Holes'+strmid(oivis2.insname,ipos,3)
	oit3.arrname=arrname
	oit3.insname='7Holes'+strmid(oit3.insname,ipos,3)
	if n_elements(oivis) ne 0 then begin
		oivis.arrname=arrname
		oivis.insname='7Holes'+strmid(oivis.insname,ipos,3)
	endif
	oiwavelength.insname=arrname
;	Merge identical wavelength tables
	oiwavelength=oiwavelength[0]
	*oiwavelength[0].eff_band=1e-6
	fixed=1
endif
if fixed then print,'Warning: SAM data from T-ReCS fixed!'
;
; ... issue with SAM data from NACO (written by Peter):
; 	arrname, insname, time not set
fixed=0
if dates[0] eq '2012-03-12' and arrnames[0] eq 'Fizeau Masking' then begin
	print,'Fixing NACO Fizeau masking data...'
	arrname='NACO'
	apertures=system_config(arrname,'STATIONS')
	num_tel=n_elements(apertures)
	oiarray=replicate(oiarray,num_tel)
	oiarray.arrname=arrname
	oiarray.tel_name=apertures
	oiarray.sta_name=apertures
	oiarray.sta_index=indgen(num_tel)
	case nint(*oiwavelength.eff_wave*1e8) of
		218:begin
		    band='_Ks'
		    *oiwavelength.eff_band=0.4e-6
		    end
		380:begin
		    band='_Lp'
		    *oiwavelength.eff_band=0.6e-6
		    end
	endcase
	insname='7Holes'+band
	oivis2.arrname=arrname
	oivis2.insname=insname
	oivis2.time=hms2h(strmid(oivis2.date_obs,11,13))*3600
	oivis2.date_obs=dates[0]
	oit3.arrname=arrname
	oit3.insname=insname
	oit3.time=hms2h(strmid(oit3.date_obs,11,13))*3600
	oit3.date_obs=dates[0]
	if n_elements(oivis) ne 0 then begin
		oivis.arrname=arrname
		oivis.insname=insname
		oivis.time=hms2h(strmid(oivis.date_obs,11,13))*3600
		oivis.date_obs=dates[0]
	endif
	oiwavelength.insname=insname
	if n_elements(oivis2) ne 0 then begin
	if total(oivis2.sta_index) eq 0 then begin
;		If the data were edited, we need to restore an original
;		full data set to match the (u,v) coordinates and identify IDs
		case nint(*oiwavelength.eff_wave*1e8) of
			218: n=168
			380: n=147 ; new file has 252, but 252/21=12 => OK!
		endcase
		index0=indgen(n)
		index=intarr(n_elements(oivis2))
		if n_elements(oivis2) lt n then begin
			case nint(*oiwavelength.eff_wave*1e8) of
				218:	begin
;					Restore ucoord0 and vcoord0
					restore,'2012-03-12_Ks.xdr'
					a=-0.0085
					end
				380:	begin
					restore,'2012-03-12_Lp.xdr'
					a=-0.0085
					a=0
					end
			endcase
;			Rotate coordinates to match
			ucoord=oivis2.ucoord*cos(a)-oivis2.vcoord*sin(a)
			vcoord=oivis2.vcoord*cos(a)+oivis2.ucoord*sin(a)
			for i=0,n_elements(index)-1 do begin
				k=where(abs(ucoord0-ucoord[i]) lt 0.001 and $
					abs(vcoord0-vcoord[i]) lt 0.001,count)
				if count eq 1 then begin
					index[i]=k
					oivis2[i].sta_index=sta_index0[*,k]
				endif
			endfor
		endif else begin
			nb=(num_tel-1)*num_tel/2
			epochs=strcompress(oivis2.date_obs $
				+oitarget[oivis2.target_id].target $
				+string(oivis2.time),/remove_all)
			ns=n_elements(unique(epochs))
			i=0
			j=1
			for n=0,ns-1 do begin
			for k=0,nb-1 do begin
			oivis2[k+n*nb].sta_index=[i,j]
			j=j+1
			if j eq num_tel then begin
				i=i+1
				j=i+1
			endif
			if i eq num_tel-1 then begin
				i=0
				j=1
			endif
			endfor
			endfor
			ucoord0=oivis2.ucoord
			vcoord0=oivis2.vcoord
			sta_index0=oivis2.sta_index
			case nint(*oiwavelength.eff_wave*1e8) of
			218:save,ucoord0,vcoord0,sta_index0, $
				filename='2012-03-12_Ks.xdr'
			380:save,ucoord0,vcoord0,sta_index0, $
				filename='2012-03-12_Lp.xdr'
			endcase
		endelse
	endif
	endif
	if n_elements(oit3) ne 0 then begin
	if total(oit3.sta_index) eq 0 then begin
		for k=0,n_elements(oit3)-1 do begin
			i=where(oivis2.ucoord eq oit3[k].u1coord $
			    and oivis2.vcoord eq oit3[k].v1coord)
			oit3[k].sta_index(0)=oivis2[i].sta_index(0)
			oit3[k].sta_index(1)=oivis2[i].sta_index(1)
			i=where(oivis2.ucoord eq oit3[k].u2coord $
			    and oivis2.vcoord eq oit3[k].v2coord)
			oit3[k].sta_index(2)=oivis2[i].sta_index(1)
		endfor
	endif
	endif
	fixed=1
endif
if fixed then print,'Warning: Fizeau masking data from NACO fixed!'
;
; ...issue with SAM data from NACO (written by Sylvestre):
; 	all time stamps identical to MJD
fixed=0
if arrnames[0] eq 'NACO' and insnames[0] eq 'SAM' then begin
	if total(oivis2.time-oivis2.mjd) eq 0 then $
		oivis2.time=(oivis2.mjd mod 1)*86400
	oivis2.date_obs=strmid(oivis2.date_obs,0,10)
	oit3.date_obs=strmid(oit3.date_obs,0,10)
	fixed=1
endif
if fixed then print,'Warning: SAM data from NACO fixed!'
;
;...unknown issue?
fixed=0
if arrnames[0] eq 'VLTI' and strpos(insnames[0],'SPECTRO') eq 0 then begin
	oivis2.time=oivis2.time-43200.0
	index=where(oivis2.time lt 0,count)
	if count gt 0 then oivis2.time[index]=oivis2.time[index]+86400.0
	if n_elements(oivis) ne 0 then begin
	oivis.time=oivis.time-43200.0
	index=where(oivis.time lt 0,count)
	if count gt 0 then oivis.time[index]=oivis.time[index]+86400.0
	endif
	if n_elements(oit3) ne 0 then begin
	oit3.time=oit3.time-43200.0
	index=where(oit3.time lt 0,count)
	if count gt 0 then oit3.time[index]=oit3.time[index]+86400.0
	endif
	fixed=1
endif
if fixed then print,'Warning: Beauty contest data fixed (SPECTRO)!'
;
;...Contest 2020, different arrays have same time stamps
fixed=0
if dates[0] eq '2019-06-02' and $
   n_elements(unique(oiarray.sta_index)) eq 34 and $
   n_elements(oivis2) eq 6*3*3 and $
   strpos(oiwavelength[0].insname,'MATISSE') eq 0 then begin
   	n=n_elements(oivis2)
	bl=strarr(n)
	sta_index=string(oivis2.sta_index)
   	for i=0,n-1 do bl[i]=strjoin(sta_index[*,i])
	oivis2.time=oivis2.time $
		+indgen(n_elements(oivis2.time))/n_elements(unique(bl))
	oivis2.mjd=oivis2.mjd $
		+(indgen(n_elements(oivis2.mjd))/n_elements(unique(bl)))/86400.
	oivis.time=oivis.time $
		+indgen(n_elements(oivis.time))/n_elements(unique(bl))
	oivis.mjd=oivis.mjd $
		+(indgen(n_elements(oivis.mjd))/n_elements(unique(bl)))/86400.
   	n=n_elements(oit3)
	tr=strarr(n)
	sta_index=string(oit3.sta_index)
   	for i=0,n-1 do tr[i]=strjoin(sta_index[*,i])
	oit3.time=oit3.time $
		+indgen(n_elements(oit3.time))/n_elements(unique(tr))
	oit3.mjd=oit3.mjd $
		+(indgen(n_elements(oit3.time))/n_elements(unique(tr)))/86400.
	fixed=1
endif
if fixed then print,'Warning: fixed Beauty contest data 2020 (time stamps)!'
;
;...Contest 2020, oiarray contains more stations than needed
fixed=0
reduce_oiarray=0
if dates[0] eq '2022-01-18' then begin
if n_elements(oivis2) gt 0 then begin
	sta_index=unique(oivis2.sta_index)
	oiv_index=oivis2.sta_index
	if n_elements(whereindex(sta_index,oiarray.sta_index)) lt $
	   n_elements(oiarray) then begin
		reduce_oiarray=1
		for i=1,n_elements(sta_index) do begin
			j=where(oiv_index[0,*] eq sta_index[i-1],n_j)
			k=where(oiv_index[1,*] eq sta_index[i-1],n_k)
			if n_j ge 1 then oivis2[j].sta_index(0)=i
			if n_k ge 1 then oivis2[k].sta_index(1)=i
		endfor
	endif
endif
if n_elements(oivis) gt 0 then begin
	sta_index=unique(oivis.sta_index)
	oiv_index=oivis.sta_index
	if n_elements(whereindex(sta_index,oiarray.sta_index)) lt $
	   n_elements(oiarray) then begin
		reduce_oiarray=1
		for i=1,n_elements(sta_index) do begin
			j=where(oiv_index[0,*] eq sta_index[i-1],n_j)
			k=where(oiv_index[1,*] eq sta_index[i-1],n_k)
			if n_j ge 1 then oivis[j].sta_index(0)=i
			if n_k ge 1 then oivis[k].sta_index(1)=i
		endfor
	endif
endif
if n_elements(oit3) gt 0 then begin
	sta_index=unique(oit3.sta_index)
	oit_index=oit3.sta_index
	if n_elements(whereindex(sta_index,oiarray.sta_index)) lt $
	   n_elements(oiarray) then begin
		reduce_oiarray=1
		for i=1,n_elements(sta_index) do begin
			j=where(oit_index[0,*] eq sta_index[i-1],n_j)
			k=where(oit_index[1,*] eq sta_index[i-1],n_k)
			l=where(oit_index[2,*] eq sta_index[i-1],n_l)
			if n_j ge 1 then oit3[j].sta_index(0)=i
			if n_k ge 1 then oit3[k].sta_index(1)=i
			if n_l ge 1 then oit3[l].sta_index(2)=i
		endfor
	endif
endif
if reduce_oiarray then begin
	oiarray=oiarray[sta_index-1]
	oiarray.sta_index=indgen(n_elements(oiarray))+1
	fixed=1
endif
if fixed then print,'Warning: cleaned up Beauty contest data (OIARRAY)!'
endif
;
end
