function checkdata,items
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Check whether particular data item is loaded; return error code otherwise.
;
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common InchData,Sol0,SolN,Jscan,MetroTime,PivotMotion, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
num_items=n_elements(items)
if num_items eq 0 then begin
	print,'***Error(CHECKDATA): no items specified!'
	return,-1
endif
;
returncode=0
for i=0,num_items-1 do begin
	errcode=0
	case items[i] of
		 1:if n_elements(scantable) eq 0 then errcode=items[i]
		 2:if n_elements(bgtable) eq 0 then errcode=items[i]
		 3:if n_elements(startable) eq 0 then errcode=items[i]
		 4:if n_elements(stationtable) eq 0 then errcode=items[i]
		 5:if n_elements(Date) eq 0 then errcode=items[i]
		 6:if n_elements(SystemId) eq 0 then errcode=items[i]
		 7:begin
		   result=size(GeoParms)
		   if result[n_elements(result)-2] ne 8 then errcode=items[i] $
			   else $
			   if n_elements(GeoInfo) eq 0 then GeoInfo=GeoParms
		   end
		 8:begin
		   result=size(GenConfig)
		   if result[n_elements(result)-2] ne 8 then errcode=items[i] $
			   else $
			   if n_elements(GenInfo) eq 0 then GenInfo=GenConfig
		   end
		 9:if n_elements(scans) eq 0 then errcode=items[i]
		10:if n_elements(bgscans) eq 0 then errcode=items[i]
		11:if n_elements(Rec0) eq 0 then errcode=items[i]
		12:if n_elements(bufferinfo) eq 0 then errcode=items[i]
		13:if n_elements(GeoInfo) eq 0 then errcode=items[i]
		14:if n_elements(GenInfo) eq 0 then errcode=items[i]
		15:if n_elements(GrpDelay) eq 0 then errcode=items[i]
		16:if n_elements(MetroTime) eq 0 then errcode=items[i]
		17:if n_elements(pointflagtable) eq 0 then errcode=items[i]
		18:if n_elements(bgflagtable) eq 0 then errcode=items[i]
		19:if n_elements(scanflagtable) eq 0 then errcode=items[i]
		20:if n_elements(inchflagtable) eq 0 then errcode=items[i]
		21:if n_elements(MetroConfig) eq 0 then errcode=items[i]
		22:if n_elements(positions) eq 0 then errcode=items[i]
		23:if n_elements(velocities) eq 0 then errcode=items[i]
		24:if n_elements(magnitudes) eq 0 then errcode=items[i]
	      else:errcode=-1
	endcase
	case errcode of
		-1:print,'***Error(CHECKDATA): unknown item id:',items[i]
		 0:errcode=0
		 1:print,'***Error(CHECKDATA): scantable does not exist!'
		 2:print,'***Error(CHECKDATA): bgtable does not exist!'
		 3:print,'***Error(CHECKDATA): startable does not exist!'
		 4:print,'***Error(CHECKDATA): stationtable does not exist!'
		 5:print,'***Error(CHECKDATA): Date undefined!'
		 6:print,'***Error(CHECKDATA): SystemId undefined!'
		 7:print,'***Error(CHECKDATA): GeoParms undefined or corrupt!'
		 8:print,'***Error(CHECKDATA): GenConfig undefined or corrupt!'
		 9:print,'***Error(CHECKDATA): no ScanData!'
		10:print,'***Error(CHECKDATA): no BackgndData!'
		11:print,'***Error(CHECKDATA): no PointData!'
		12:print,'***Error(CHECKDATA): no bufferinfo!'
		13:print,'***Error(CHECKDATA): no GeoInfo!'
		14:print,'***Error(CHECKDATA): no GenInfo!'
		15:print,'***Error(CHECKDATA): no DelayData!'
		16:print,'***Error(CHECKDATA): no InchData!'
		17:print,'***Error(CHECKDATA): no pointflagtable!'
		18:print,'***Error(CHECKDATA): no bgflagtable!'
		19:print,'***Error(CHECKDATA): no scanflagtable!'
		20:print,'***Error(CHECKDATA): no inchflagtable!'
		21:print,'***Error(CHECKDATA): MetroConfig undefined!'
		22:print,'***Error(CHECKDATA): Positions undefined!'
		23:print,'***Error(CHECKDATA): Velocities undefined!'
		24:print,'***Error(CHECKDATA): Magnitudes undefined!'
	endcase
	if errcode ne 0 then returncode=-1
endfor
return,returncode
end
