function checkdate
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; If observations began before 0 UT, OYSTER sets the date to the
; previous day in order to avoid negative timestamps. This functions returns
; a unique date (the UT date) by detecting these circumstances.
;
; If the timestamps exceed 48 hours, this is a multinight observation
; and in this case we do not change the date. (This case happens with
; VINCI data for example.)
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(scantable) ne 0 then time=scantable.starttime
if n_elements(scans) ne 0 then time=scans.time
;
if max(abs(time)/3600) gt 24 and max(abs(time)/3600) lt 48 $
			     then return,nextdate(date) $
			     else return,date
;
end
