pro checkimages
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Check that images exist for the entire wavelength range specified in genconfig
;
common ChannelImage,channel_images,channel_wavelengths,images_cellsize
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(genconfig) eq 0 then begin
	print,'No check possible: GenConfig not loaded.'
	return
endif
;
nx=n_elements(channel_images[*,0,0])
ny=n_elements(channel_images[0,*,0])
;
for i=0,genconfig.numoutbeam-1 do begin
index=where(scans.vissqerr[i,*,*] gt 0,count)
if count gt 0 then begin
;
minw=min(channel_wavelengths)
maxw=max(channel_wavelengths)
minl=min(genconfig.wavelength[0:genconfig.numspecchan[i]-1,i])
maxl=max(genconfig.wavelength[0:genconfig.numspecchan[i]-1,i])
;
nz=n_elements(channel_images[0,0,*])
if minl lt minw then begin
	print,'Warning: min.lambda cube > min.lambda genconfig): ', $
		minw*1e6,minl*1e6
	print,'Adding image(min.lambda cube) for min.lambda...'
	channel_wavelengths=[minl,channel_wavelengths]
	images=channel_images
	channel_images=fltarr(nx,ny,nz+1)
	channel_images[*,*,0]=images[*,*,0]
	channel_images[*,*,1:nz]=images
endif
nz=n_elements(channel_images[0,0,*])
if maxl gt maxw then begin
	print,'Warning: max.lambda cube < max.lambda genconfig): ', $
		minw*1e6,minl*1e6
	print,'Adding image(max.lambda cube) for max.lambda...'
	channel_wavelengths=[channel_wavelengths,maxl]
	images=channel_images
	channel_images=fltarr(nx,ny,nz+1)
	channel_images[*,*,0:nz-1]=images
	channel_images[*,*,nz]=images[*,*,nz-1]
endif
;
endif
endfor
;
end
