pro checknovas
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
get_startable,['BSC0424','BSC1851','BSC4199']
rename_bsc
stars=startable.starid
;
startable.ra=[2.5301955556d0,5.5334438889d0,10.7159355556d0]
startable.dec=[89.2640888889d0,-0.2991333333d0,-64.3944666667d0]
startable.pmra=[19.8770,0.0100,-0.3480]
startable.pmdec=[-1.520,-0.220,1.000]
startable.px=[0.0070,0.0140,0.0000]
startable.rv=[-17.0,16.0,24.0]
;
get_geoparms
geoparms.latitude=45.0
geoparms.longitude=-75.0
geoparms.altitude=0.0
;
dates=['1996-04-30','1996-04-30','1996-11-30','1996-08-05']
times=dblarr(n_elements(startable))-60.
geoparms.tai_utc=30
geoparms.tdt_tai=30
geoparms.ut1utc_coeffs=0
;
for i=0,n_elements(dates)-1 do begin
	date=dates[i]
	topostar,times,stars,startable,ra_app,dec_app
	print,startable.name
	print,ra_app,format='(4(f12.9,2x))'
	print,dec_app,format='(4(f12.8,2x))'
endfor
;
end
