function checkplotsel,stream
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compares plot selection to GenConfig information. If OK, returns 0.
; Returns error code if selection is incomplete or invalid.
; Note: pt selection is not checked!
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
;
if n_elements(stream) eq 0 then return,-1
;
if n_elements(class) eq 0 then return,1
if n_elements(slice) eq 0 then return,2
;
if n_elements(ds_nights) eq 0 then return,3
if n_elements(ds_stars) eq 0 then return,4
;
set_streamsel,stream,item,ds_ib,ds_ob,ds_tr,ds_ch,ds_bl,ds_pt
;
if n_elements(ds_ib) eq 0 then return,5
if n_elements(ds_ob) eq 0 then return,6
if n_elements(ds_tr) eq 0 then return,7
if n_elements(ds_ch) eq 0 then return,8
if n_elements(ds_bl) eq 0 then return,9
;
if (ds_ib lt 0) or $
   (ds_ib ge GenConfig.NumSid and GenConfig.NumSid ne 0) then return,10
if (ds_ob lt 0) or $
   (ds_ob ge GenConfig.NumOutBeam and GenConfig.NumOutBeam ne 0) then return,11
if item ge 28 and item le 33 then begin ; Data from different nightly configs
if (ds_tr lt 0) or $
   (ds_tr ge GenConfig.NumTriple and GenConfig.NumTriple ne 0) then return,12
endif
;
index=where((ds_ch ge 0) and (ds_ch lt GenConfig.NumSpecChan[ds_ob]),count)
num_sel=n_elements(ds_ch)
check=[3,4,5,8,21,24,25,26,27,34,35,45,46,50,51,52]
if (count lt num_sel) and ((long(where(check eq item),0) ne -1) $
			    or strpos(type,'V2Bias') ge 0 $
			    or strpos(type,'APDFlux') ge 0 $
			    or strpos(type,'Response') ge 0 $
			    or strpos(type,'TrackJitter') ge 0 $
			    or strpos(type,'TrackOffset') ge 0) then return,13
;
; Data might include different nightly configs
if GenConfig.NumTriple gt 0 and item ge 28 and item le 33 then begin
index=where((ds_ch ge 0) and (ds_ch lt GenConfig.TripleNumChan[ds_tr[0]]),count)
check=[6,7,28,29,30,31,32,33,58,59]
if long(where(check eq item),0) ne -1 and GenConfig.NumTriple eq 0 $
							then return,15
if (count lt num_sel) and ((long(where(check eq item),0) ne -1) $
			    or strpos(type,'TABias') ge 0) then return,13
endif
;
index=where((ds_bl ge 0) and (ds_bl lt GenConfig.NumBaseline[ds_ob]),count)
num_sel=n_elements(ds_bl)
check=[3,4,5,10,24,25,26,27,37,38,47,48,50,51,52,90,91]
if (count lt num_sel) and ((long(where(check eq item),0) ne -1) $
			    or strpos(type,'V2Bias') ge 0) then return,14
;
return,0
;
end
