function chmap,model,lamda,threshold=threshold
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given an image cube, interpolate image at wavelength lamda [m].
; Returns a map. Sets all pixels to zero which are less than a threshold.
;
; Map coordinates are in mas.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ChannelImage,channel_images,channel_wavelengths,images_cellsize
;
RAD=180/pi_circle
if n_elements(threshold) eq 0 then threshold=0.001
;
wavelengths=channel_wavelengths
;
if total(channel_images) eq 0 then retall
;
IF n_elements(channel_wavelengths) EQ 1 THEN BEGIN
;
image=channel_images
;
ENDIF ELSE BEGIN
;
i=where(wavelengths ge lamda,count)
if count eq 0 then begin
	image=channel_images[*,*,n_elements(wavelengths)-1]
endif else if count eq n_elements(wavelengths) then begin
	image=channel_images[*,*,0]
endif else begin
	dll=(lamda-wavelengths[i[0]-1])/(wavelengths[i[0]]-wavelengths[i[0]-1])
	dlh=(wavelengths[i[0]]-lamda)  /(wavelengths[i[0]]-wavelengths[i[0]-1])
;
; 	Linearily interpolate images to wavelength desired
	image=channel_images[*,*,i[0]-1]*dlh+channel_images[*,*,i[0]]*dll
endelse
;
ENDELSE
;
; Remove DC component
; image=image-sockel(image)
;
r=size(image)
imsize=r[1:2]
x=(lindgen(imsize[0]*imsize[1]) mod imsize[0]) - (imsize[0]/2)
y=(lindgen(imsize[0]*imsize[1]) / imsize[0]) - (imsize[1]/2)
x=-x*images_cellsize   ; RA increases to the left (East)
y=+y*images_cellsize
;
if max(image) ne 0 $
	then index=where(image/max(image) ge threshold,count) $
	else index=where(image eq 0,count)
f=reform(image[index],count)
x=x[index]
y=y[index]
icc=lindgen(count)
ccc=icc	; ccc is not used here
map=alloc_map(icc,ccc,x,y,f,imsize[0],imsize[1])
;
return,map
;
end
