pro clean,ch,cm,rm,db,cc,rt,rf,quiet=quiet;,fl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Deconvolve the residual map (rm) from the dirty beam (db) and return a map
; of the subtracted clean components (cc) and the residual map (rm).
; Do exactly niter iterations, and store these locally.
;
; Note: this is a multiwavelength CLEAN.
;
common LocalClean,rmmaps,ccmaps,niter,niter_total
;
if n_params() eq 1 then begin
	quiet=1
	j=ch
	clean_bridge_data='clean_bridge_'+string(j,format='(i1)')+'.xdr'
	restore,clean_bridge_data	; also restore ch
endif
;
if n_elements(ch) eq 0 then ch=0
if n_elements(quiet) eq 0 then quiet=0
;
niter_max=100
;
if niter eq 0 then niter=niter_max
;
if niter le niter_max then begin
	rmmaps=replicate({map:rm.maps[ch].map*0},niter+1)
	ccmaps=replicate({map:cc.maps[ch].map*0},niter+1)
	rmmaps[0].map=rm.maps[ch].map
endif
;
dbxsize=n_elements(db.maps[ch].map(*,0))
dbysize=n_elements(db.maps[ch].map(0,*))
rmxsize=n_elements(rm.maps[ch].map(*,0))
rmysize=n_elements(rm.maps[ch].map(0,*))
;
nc=n_elements(rf[*,0])
nr=where(rt ne 0)
gain=0.1
;
for k=0,niter-1 do begin
	if ch eq 0 then rm_map=clbox(rm,ch) $
		   else rm_map=cmpix(rm,ch,cm)
	maxrm=max(rm_map)
	scale=maxrm*gain
;	Find maximum in current residual map
	index=where(rm_map eq maxrm) & index=index[0]
	i=(index mod rmxsize)-rmxsize/2
	j=(index/rmxsize)-rmysize/2
;	Cut-out patch of dirty beam centered on peak and size of RM
	dbs=db.maps.map[dbxsize/2-i-rmxsize/2:dbxsize/2-i+rmxsize/2, $
		   	dbysize/2-j-rmysize/2:dbysize/2-j+rmysize/2]*scale
	IF ch eq 0 THEN BEGIN
;	Broad-band CLEAN for ch=0 (white light channel)
	m=where(rt[nr] eq cc.teff[i+rmxsize/2,j+rmysize/2]) & m=m[0]
;	New code using SED, rf normalized when defining region
	flux_scale=total(rf[*,m])/nc
;	Subtract dirty beam in each channel from RM
;	flux=rf(*,0)*0+1
;	for l=0,nc-1 do $
;	rm.maps(ch).map=rm.maps(ch).map $
;		       -dbs(*,*,l+1)*(rf(l,m)/flux(l))/flux_scale
	dbs=dbs/flux_scale
	for l=0,nc-1 do $
	rm.maps[ch].map-=dbs[*,*,l+1]*rf[l,m]
	ENDIF ELSE BEGIN
;	Classic CLEAN
	flux_scale=1
	rm.maps[ch].map-=dbs[*,*,ch]*nc
	ENDELSE
	cc.maps[ch].map(i+rmxsize/2,j+rmysize/2)+=scale/flux_scale
	if ch eq 0 and niter le niter_max then begin
		rmmaps[k+1].map=rm.maps[ch].map
		ccmaps[k+1].map=cc.maps[ch].map
	endif
endfor
;
if not quiet then $
print,'CLEAN complete.'
;
if n_params() eq 1 then save,rm,cc,file=clean_bridge_data
;
end
