function clean_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; CLEAN is run whenever the cc map is empty. The "Take" option allows
; to clean more than 100 components (the default range for CLEAN) which
; are aggregated in CM.
;
common LocalPearl,star,pearl_channel
common PearlWids,draw_wid,clean_wid,channel_wid
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common LocalClean,rmmaps,ccmaps,niter,niter_total
;
if widget_info(draw_wid,/valid) ne 0 and !d.name ne 'PS' then begin
	widget_control,draw_wid,get_value=win_num
	wset,win_num
endif
ch=pearl_channel
;
if n_elements(niter) eq 0 then niter=100
if n_elements(niter_total) eq 0 then niter_total=intarr(n_elements(unique(ci))+1
if n_elements(ccmaps) eq 0 then $
	ccmaps=replicate({map:cc.maps[ch].map*0},1)
;
case string(event.value) of
;	Call-back for combined CLEAN buttons
	'Take' :begin
		dm.maps[ch].map=rm.maps[ch].map
		cm.maps[ch].map=cm.maps[ch].map+cc.maps[ch].map
		cc.maps[ch].map=0
		ccmaps.map=0
		niter_total[ch]=niter_total[ch]+niter
		niter=0
		r=set_scale(rm,ch)
		tvrm,ch
		tvcc,ch
		tvfm,ch
	       	widget_control,clean_wid,set_value=0
		widget_control,channel_wid,sensitive=1
		end
	'Update':begin
		cm.maps[ch].map=cm.maps[ch].map+cc.maps[ch].map
		cc.maps[ch].map=0
		ccmaps.map=0
		niter_total[ch]=niter_total[ch]+niter
		niter=0
		ir=where(rt ne 0,nr)
		if nr gt 0 then residualmap,ch
		r=set_scale(rm,ch)
		tvrm,ch
		tvfm,ch
		tvcc,ch
	       	widget_control,clean_wid,set_value=0
		widget_control,channel_wid,sensitive=1
	       	end
	'Cycle':begin
		if total(abs(ccmaps.map)) ne 0 then begin
			cm.maps[ch].map=cm.maps[ch].map+cc.maps[ch].map
			cc.maps[ch].map=0
			ccmaps.map=0
			niter_total[ch]=niter_total[ch]+niter
	       		widget_control,clean_wid,set_value=0
			mv=mft(cm,mv*0,uc,vc,ci,rt,rf,ch)
			selfcal
			print,'Computing dirty map...'
			dirtymap,ch
		endif
		device,cursor_standard=150
		niter=niter_total[ch]
		print,'Running '+string(niter,format='(i3)') $
			+' CLEAN iterations...',format='(a,$)'
		clean,ch,cm,rm,db,cc,rt,rf;,fl
		print,'Finished CLEAN.'
		device,/cursor_original
		cm.maps[ch].map=cc.maps[ch].map
		cc.maps[ch].map=0
		ccmaps.map=0
		print,'Running self cal...'
		mv=mft(cm,mv*0,uc,vc,ci,rt,rf,ch)
		selfcal
		print,'Computing dirty map...'
		dirtymap,ch
		tvfm
		tvrm
		cm.maps[ch].map=0
	       	end
	'Help': begin
		print,'Combined CLEAN slider (drag to start):'
		print,'Take: add components to model'
		print,'Update: add components and run selfcal'
		print,'Cycle: add components, selfcal, CLEAN for new DM'
		end
;	Call-back for channel buttons
	'Remove' :begin
		if ch ge 1 then begin
		 	print,'Removing clean components from map...',format='(a,$)'
		 	cc.maps[ch].map=0
		 	cm.maps[ch].map=0
		 	rm.maps[ch].map=0
		 	diffmap,ch
		 	tvrm,ch
		 	tvfm,ch
		 	tvcm,ch
		 	print,'done.'
		endif else begin
			print,'Cannot clear combined map with this button!'
		endelse
		end
	'Clean':begin
		index=where(cm.maps[0].map ne 0,count)
		if count eq 0 then niter=300 $
			      else niter=niter_total[ch]
		print,'Number of iterations to clean: ',niter
		nc=n_elements(db.maps)
		for ch=1,nc-1 do begin
			widget_control,channel_wid,set_value=ch
			dirtymap,ch
			cc.maps[ch].map=0
			print,string(13b), $
				'Cleaning channel '+string(ch)+'...', $
				format='(a,a,$)'
			clean,ch,cm,rm,db,cc,rt,rf,/quiet
			dm.maps[ch].map=rm.maps[ch].map
			cm.maps[ch].map=cc.maps[ch].map
			cc.maps[ch].map=0
			tvdb,ch
			tvfm,ch
			tvrm,ch
		endfor
		print,''
;		widget_control,channel_wid,set_value=pearl_channel
		widget_control,channel_wid,set_value=1
		end
	'Contour':begin
		if !d.name ne 'PS' then window,/free,xsize=550,ysize=500
		if ch ge 1 then $
		!p.title='Channel '+string(ch,format='(i2)')+' map' $
		else $
		!p.title='PEARL CLEAN map'
		tkfm,ch
		if !d.name eq 'PS' then begin
			device,/close
;			set_plot,!display
			set_screen
		endif
		widget_control,draw_wid,get_value=id
		wset,id
		device,decompose=0
		end
	'Calibrate':begin
		teffmap
		end
	'T-Map':begin
		tvet
		rtu=unique(rt[where(rt ne 0)])
		n=n_elements(rtu)
		rtc=intarr(n)
		for i=0,n-1 do begin
			index=where(cm.teff eq rtu[i],count)
			rtc[i]=count
		endfor
		print,'Effective temperature regions and areas (pixel): '
		for i=0,n-1 do print,rtu[i],rtc[i]
		end
	'T-Init': begin
		pearlinit
		end
	'HELP': begin
		print,'Remove: remove clean components from selected channel map'
		print,'Clean: clean *all* channels; use windows if combined map was cleared'
		print,'Contour: plot a contour map of the selected channel'
		print,'Calibrate: compute and install new Teff map'
		print,'T-Map: display color Teff map'
		print,'T-Init: initialize Teff map'
		end
	'Cleanup': begin
;		Call back for when PEARL GUI is closed
		if n_elements(ccmaps) ne 0 then ccmaps.map=0
		niter_total[*]=0
		end
	else: 	begin
;		Call-back for clean and channel sliders
		if event.id eq channel_wid then begin
			pearl_channel=event.value
			ch=pearl_channel
; 			Reset the total CLEAN counter if we start with an empty map
			if total(rm.maps[ch].map) eq 0 then begin
				niter_total[ch]=0
				dirtymap,ch
				r=set_scale(rm,ch)
			endif
			tvdb,ch
			tvrm,ch
			tvfm,ch
		endif
		if event.id eq clean_wid then begin
			widget_control,channel_wid,sensitive=0
			if n_elements(ccmaps) eq 0 then $
			ccmaps=replicate({map:cc.maps[ch].map*0},1)
			if total(abs(ccmaps.map)) eq 0 then begin
				device,cursor_standard=150
				print,'Running CLEAN...',format='(a,$)'
				niter=0
				clean,ch,cm,rm,db,cc,rt,rf;,fl
				print,'Finished CLEAN.'
				device,/cursor_original
;				cleanmovie,ccmaps,rmmaps,cb
			endif
			widget_control,event.id,get_value=value
			niter=fix(value)
			rm.maps[ch].map=rmmaps[niter].map
			cc.maps[ch].map=ccmaps[niter].map
			tvrm,ch
			tvcc,ch
			tvfm,ch
		endif
		end
endcase
;
end
