pro clean_parallel
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common LocalClean,rmmaps,ccmaps,niter,niter_total
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common PearlWids,draw_wid,clean_wid,channel_wid
;
spawn,'pwd',local_dir & local_dir=local_dir[0]
;
n_cpu=!cpu.hw_ncpu
clean_bridge=objarr(n_cpu)
clean_bridge_data=strarr(n_cpu)
for j=0,n_cpu-1 do begin
	clean_bridge[j]=obj_new('IDL_IDLBridge')
	clean_bridge[j]->execute,"cd,'"+local_dir+"'"
	clean_bridge[j]->execute,".run ~/oyster/source/common/pearl.pro"
	clean_bridge_data[j]='clean_bridge_'+string(j+1,format='(i1)')+'.xdr'
endfor
;
index=where(cm.maps[0].map ne 0,count)
if count eq 0 then niter=300 $
	      else niter=niter_total[0]
print,'Number of iterations to clean: ',niter
;
nc=n_elements(db.maps)
n_iter=nc/n_cpu
;
FOR i=0,n_iter DO BEGIN
;
print,string(13b),'Cleaning channels ' $
	+string((i*n_cpu+1) < (nc-1),format='(i4)')+' - ' $
	+string((i+1)*n_cpu < (nc-1),format='(i4)'), $
				format='(a,a,a,a,a,$)'
if i eq 0 then clock=tic('clock')
;
for j=0,n_cpu-1 do begin
	ch=i*n_cpu+j+1
	if ch lt nc then begin
		dirtymap,ch
		cc.maps[ch].map=0
		save,ch,rm,db,cc,rt,rf,cm,niter,file=clean_bridge_data[j]
		clean_bridge[j]->execute,"clean,"+string(j+1),/nowait
	endif
endfor
;
; After sleeping (no CPU used for main process),
; stay in while loop until all processes finish.
if i ne 0 then wait,sleep
notdone = 1
while notdone do begin
	done=0
	for j=0,n_elements(clean_bridge)-1 do $
		done = done+clean_bridge[j]->Status()
	if done eq 0 then notdone=done
endwhile
if i eq 0 then sleep=fix(toc(clock)*0.6) > 1
;
; print,'Getting results...'
;
for j=0,n_cpu-1 do begin
	ch=i*n_cpu+j+1
	if ch lt nc then begin
		rm_bck=rm
		cc_bck=cc
		restore,file=clean_bridge_data[j]	; restores rm, cc
		dm.maps[ch].map=rm.maps[ch].map
		cm.maps[ch].map=cc.maps[ch].map
		cc.maps[ch].map=0
		widget_control,channel_wid,set_value=ch
		tvdb,ch
		tvfm,ch
		tvrm,ch
		rm_bck.maps[ch].map=rm.maps[ch].map
		cc_bck.maps[ch].map=cc.maps[ch].map
		rm=rm_bck
		cc=cc_bck
	endif
endfor
;
ENDFOR
;
print,''
print,'Cleaning up processes...'
for j=0,n_cpu-1 do begin
	obj_destroy,clean_bridge[j]
	spawn,'rm -f '+clean_bridge_data[j]
endfor
;
widget_control,channel_wid,set_value=1
;
end
