function cleanbeam,beam,scale,level=level,blank=radius
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return major and minor axis, and position angle [deg] of FWHM clean beam
; ellipse. Iterate to find optimum level to avoid sidelobe contamination.
;
common BeamInfo,reduce
common FitEllipse,ex,ey
;
if not keyword_set(scale) then scale=1.
;
; These are passed to function beampatch
if n_elements(level) eq 0 then level=0.2
if n_elements(radius) eq 0 then radius=0
;
RAD=180/!pi
;
m=max(beam)
;
; Skipped, see iterative loop below
if 0 then begin
index=where(beam gt m/2-m/15 and beam lt m/2+m/15 $
	and beampatch(beam,level=level,radius=radius) eq 1,ndata)
if ndata lt 8 then begin
	print,'***Error(CLEANBEAM): too few half-maximum points!'
	return,-1
endif
imsize=n_elements(beam[0,*])
; Set data.
x=(index mod imsize)*(180/!pi)/(imsize*reduce)*3600e3 & x=x-avg(x)
y=(index/imsize)*(180/!pi)/(imsize*reduce)*3600e3 & y=y-avg(y)
endif
;
; Loop to avoid sidelobes starting at input level
repeat begin
	index=where(beam gt m/2-m/15 and beam lt m/2+m/15 $
		and beampatch(beam,level=level,radius=radius) eq 1,ndata)
	if ndata lt 8 then begin
		print,'***Error(CLEANBEAM): too few half-maximum points!'
		return,-1
	endif
	imsize=n_elements(beam[0,*])
; 	Set data.
	x=(index mod imsize)*(180/!pi)/(imsize*reduce)*3600e3 & x=x-avg(x)
	y=(index/imsize)*(180/!pi)/(imsize*reduce)*3600e3 & y=y-avg(y)
;	Plot beam patch at current level
;	plot,x,y & wait,1
; 	Check for "sidelobes"
	r=poly_fit(x,y,1,yfit)
	xs=x[sort(x)]
	nel=n_elements(xs)
	uxs=unique(xs[1:nel-1]-xs[0:nel-2])
	level=level+0.1
endrep until max(uxs) lt 0.6	; The value for level needs to be justified...
print,'Optimum level to suppress sidelobes: ',level-0.1
;
r=sqrt(x^2+y^2)
p=!pi-atan(x,y)
;
; Set parameters to fit
ma=5
ia=lonarr(ma)+1 & ia[0]=0 & ia[1]=0
index=where(ia ne 0,mfit)
e_parms=fltarr(ma)
e_parms[0]=0
e_parms[1]=0
e_parms[2]=max(r)
e_parms[3]=min(r)
i=where(r eq max(r)) & i=i[0]
e_parms[4]=p[i]
if e_parms[4] gt !pi then e_parms[4]=e_parms[4]-!pi
a=e_parms
;
; Store ellipse data
ex=r*sin(p)
ey=r*cos(p)
;
; Call marquardt
sig=fltarr(ndata)+0.1
pa=p	; ellfuncs changes p!
marquardt,'ellfuncs',pa,r,sig,ndata,a,ia,ma,chisq,covar
;
; Plot the half-power points and fit
; plot,-x,y,psym=1
; r=ellipse(a(2),a(3),p-a(4))
; oplot,r*sin(p),r*cos(p),psym=3
;
; Set new parameters
e_parms=a
e_parms[2]=a[2]*2*scale
e_parms[3]=a[3]*2*scale
e_parms[4]=a[4]*RAD
;
return,e_parms[2:4]
;
; Print inital estimates to screen
print,'__________________________________'
print,'Center x = ',e_parms[0]
print,'Center y = ',e_parms[1]
print,'Semi-major axis [mas] = ',e_parms[2]
print,'Semi-minor axis [mas] = ',e_parms[3]
print,'Position  angle [deg] = ',e_parms[4]
print,'_______________***________________'
;
end
