function cleankernel,db,ch,aparms=aparms,mparms=mparms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the CLEAN beam, which is the central peak in the dirty beam.
; The latter is converted to a white light beam if the input is a cube.
; With aparms=[major (mas),minor (mas),pa (deg)] beam can be specified.
;
common FitEllipse,ex,ey
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(ch) eq 0 then ch=0
;
mas2rad=pi_circle/(180l*3600000l)
rad=180/!pi
;
map=db.maps[ch].map
index=where(map eq max(map))
;
imsize=n_elements(map[*,0])
jmsize=n_elements(map[0,*])
;
cellsize=db.x[0]-db.x[1]
;
; Fit the beam size
IF n_elements(aparms) eq 0 THEN BEGIN
;
i=index[0] mod imsize
j=index[0]  /  imsize
index=[i-2,i-1,i,i+1,i+2]
jndex=[j-2,j-1,j,j+1,j+2]
;
r=findgen(5)-2
h=[0.5,0.0,0.0]*max(map)
x=fltarr(8)
y=x
; Fit quadratic polynomial, get FWHM by lowering 0.5 (max=1),
; and then solving the quadratic equation for r=0. This can
; fail if there are too few pixels across the maximum.
x[0:1]=quasol(poly_fit(r,map[index,j],2)-h)
y[2:3]=quasol(poly_fit(r,map[i,jndex],2)-h)
x[4:5]=quasol(poly_fit(r,map[index,jndex],2)-h)
y[4:5]=x[4:5]
x[6:7]=quasol(poly_fit(r,map[index,reverse(jndex)],2)-h)
y[6:7]=x[[7,6]]
;
; Set data
x=-x*cellsize/MAS2RAD
y=+y*cellsize/MAS2RAD
ndata=8
;
r=sqrt(x^2+y^2)
p=!pi-atan(x,y)
;
; Set parameters to fit
ma=5
ia=lonarr(ma)+1 & ia[0]=0 & ia[1]=0
index=where(ia ne 0,mfit)
e_parms=fltarr(ma)
e_parms[0]=0
e_parms[1]=0
e_parms[2]=max(r)
e_parms[3]=min(r)
i=where(r eq max(r)) & i=i[0]
e_parms[4]=p[i]
if e_parms[4] gt !pi then e_parms[4]=e_parms[4]-!pi
a=e_parms
;
; Store ellipse data
ex=r*sin(p)
ey=r*cos(p)
;
; Call marquardt
sig=fltarr(ndata)+0.1
pa=p    ; ellfuncs changes p!
quiet=!quiet
!quiet=1
marquardt,'ellfuncs',pa,r,sig,ndata,a,ia,ma,chisq,covar
!quiet=quiet
; Set new parameters
e_parms=a
e_parms[2]=a[2]*2*mas2rad
e_parms[3]=a[3]*2*mas2rad
e_parms[4]=a[4]
if not !quiet then $
print,'Synthesized beam ',a[2]*2,' by ',a[3]*2, $
	' mas, pa = ',360-a[4]*rad,' degrees.'
;
ENDIF ELSE BEGIN
;
; Use the supplied beam size parameters
e_parms=fltarr(5)
e_parms[2]=aparms[0]*mas2rad
e_parms[3]=aparms[1]*mas2rad
e_parms[4]=aparms[2]/rad
;
ENDELSE
;
; Return the fit results in aparms
aparms=fltarr(3)
aparms[0]=e_parms[2]/mas2rad	; major axis in mas
aparms[1]=e_parms[3]/mas2rad	; minor axis in mas
aparms[2]=e_parms[4]*rad	; PA in degrees
;
; Determine size of kernel
csize=db.x[0]-db.x[1]	; cellsize in radians
msize=intarr(2)
msize[0]=fix(max([e_parms[3]*abs(cos(e_parms[4])), $
		  e_parms[2]*abs(sin(e_parms[4]))]/csize)) < imsize
msize[1]=fix(max([e_parms[2]*abs(cos(e_parms[4])), $
		  e_parms[3]*abs(sin(e_parms[4]))]/csize)) < jmsize
msize=msize*3		; axis is FWHM, and we the kernel further down
msize=2*(msize/2)+1	; make size an odd number
if n_elements(mparms) eq 2 then msize=mparms
mparms=msize
cbm=pearlimage(msize,csize/mas2rad)
;
el=sqrt(e_parms[2]^2-e_parms[3]^2)
en=el/e_parms[2]	; numeric eccentricity
;
r=sqrt(cbm.x^2+cbm.y^2)
a=sqrt((e_parms[3]/2)^2/(1-en^2*cos(-atan(cbm.y,cbm.x)+e_parms[4]+!pi/2)^2))
result=machar() & tiny=result.xmin*1e6 & toosmall=alog(tiny)
y=(-(r/a)^2);> toosmall
index=where(y lt toosmall,count)
if count gt 0 then y[index]=1
cbm.maps[0].map(*)=exp(y)
if count gt 0 then cbm.maps[0].map(index)=0
;
return,cbm
;
end
