function cleankernels,db,aparms=aparms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; With aparms=[major (mas),minor (mas),pa (deg)] beam can be specified.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
mas2rad=pi_circle/(180l*3600000l)
;
nc=n_elements(db.maps)
;
cbm=cleankernel(db,aparms=aparms)
r=size(cbm.maps[0].map)
cbmxsize=n_elements(cbm.maps[0].map(*,0))
cbmysize=n_elements(cbm.maps[0].map(0,*))
cellsize=(db.x[0]-db.x[1])/mas2rad
cb=pearlimage(r[1:2],cellsize,nc)
cb.maps[0].map=cbm.maps[0].map
;
!quiet=1
for j=1,nc-1 do begin
	cbm=cleankernel(db,j,aparms=aparms,mparms=r[1:2])
	cb.maps[j].map=cbm.maps[0].map
endfor
!quiet=0
;
return,cb
;
end
